package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3PhaseControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3PhaseControl
}
object Eac3PhaseControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3PhaseControl
  ): zio.aws.medialive.model.Eac3PhaseControl = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3PhaseControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3PhaseControl.NO_SHIFT =>
      val r = NO_SHIFT
      r
    case software.amazon.awssdk.services.medialive.model.Eac3PhaseControl.SHIFT_90_DEGREES =>
      val r = SHIFT_90_DEGREES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3PhaseControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3PhaseControl =
      software.amazon.awssdk.services.medialive.model.Eac3PhaseControl.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_SHIFT extends zio.aws.medialive.model.Eac3PhaseControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3PhaseControl =
      software.amazon.awssdk.services.medialive.model.Eac3PhaseControl.NO_SHIFT
  }
  case object SHIFT_90_DEGREES
      extends zio.aws.medialive.model.Eac3PhaseControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3PhaseControl =
      software.amazon.awssdk.services.medialive.model.Eac3PhaseControl.SHIFT_90_DEGREES
  }
}
