package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin1Max31, __double}
import scala.jdk.CollectionConverters._
final case class Eac3Settings(
    attenuationControl: Option[zio.aws.medialive.model.Eac3AttenuationControl] =
      None,
    bitrate: Option[__double] = None,
    bitstreamMode: Option[zio.aws.medialive.model.Eac3BitstreamMode] = None,
    codingMode: Option[zio.aws.medialive.model.Eac3CodingMode] = None,
    dcFilter: Option[zio.aws.medialive.model.Eac3DcFilter] = None,
    dialnorm: Option[__integerMin1Max31] = None,
    drcLine: Option[zio.aws.medialive.model.Eac3DrcLine] = None,
    drcRf: Option[zio.aws.medialive.model.Eac3DrcRf] = None,
    lfeControl: Option[zio.aws.medialive.model.Eac3LfeControl] = None,
    lfeFilter: Option[zio.aws.medialive.model.Eac3LfeFilter] = None,
    loRoCenterMixLevel: Option[__double] = None,
    loRoSurroundMixLevel: Option[__double] = None,
    ltRtCenterMixLevel: Option[__double] = None,
    ltRtSurroundMixLevel: Option[__double] = None,
    metadataControl: Option[zio.aws.medialive.model.Eac3MetadataControl] = None,
    passthroughControl: Option[zio.aws.medialive.model.Eac3PassthroughControl] =
      None,
    phaseControl: Option[zio.aws.medialive.model.Eac3PhaseControl] = None,
    stereoDownmix: Option[zio.aws.medialive.model.Eac3StereoDownmix] = None,
    surroundExMode: Option[zio.aws.medialive.model.Eac3SurroundExMode] = None,
    surroundMode: Option[zio.aws.medialive.model.Eac3SurroundMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Eac3Settings = {
    import Eac3Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Eac3Settings
      .builder()
      .optionallyWith(attenuationControl.map(value => value.unwrap))(
        _.attenuationControl
      )
      .optionallyWith(bitrate.map(value => value: java.lang.Double))(_.bitrate)
      .optionallyWith(bitstreamMode.map(value => value.unwrap))(_.bitstreamMode)
      .optionallyWith(codingMode.map(value => value.unwrap))(_.codingMode)
      .optionallyWith(dcFilter.map(value => value.unwrap))(_.dcFilter)
      .optionallyWith(dialnorm.map(value => value: Integer))(_.dialnorm)
      .optionallyWith(drcLine.map(value => value.unwrap))(_.drcLine)
      .optionallyWith(drcRf.map(value => value.unwrap))(_.drcRf)
      .optionallyWith(lfeControl.map(value => value.unwrap))(_.lfeControl)
      .optionallyWith(lfeFilter.map(value => value.unwrap))(_.lfeFilter)
      .optionallyWith(loRoCenterMixLevel.map(value => value: java.lang.Double))(
        _.loRoCenterMixLevel
      )
      .optionallyWith(
        loRoSurroundMixLevel.map(value => value: java.lang.Double)
      )(_.loRoSurroundMixLevel)
      .optionallyWith(ltRtCenterMixLevel.map(value => value: java.lang.Double))(
        _.ltRtCenterMixLevel
      )
      .optionallyWith(
        ltRtSurroundMixLevel.map(value => value: java.lang.Double)
      )(_.ltRtSurroundMixLevel)
      .optionallyWith(metadataControl.map(value => value.unwrap))(
        _.metadataControl
      )
      .optionallyWith(passthroughControl.map(value => value.unwrap))(
        _.passthroughControl
      )
      .optionallyWith(phaseControl.map(value => value.unwrap))(_.phaseControl)
      .optionallyWith(stereoDownmix.map(value => value.unwrap))(_.stereoDownmix)
      .optionallyWith(surroundExMode.map(value => value.unwrap))(
        _.surroundExMode
      )
      .optionallyWith(surroundMode.map(value => value.unwrap))(_.surroundMode)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Eac3Settings.ReadOnly =
    zio.aws.medialive.model.Eac3Settings.wrap(buildAwsValue())
}
object Eac3Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Eac3Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Eac3Settings =
      zio.aws.medialive.model.Eac3Settings(
        attenuationControl.map(value => value),
        bitrate.map(value => value),
        bitstreamMode.map(value => value),
        codingMode.map(value => value),
        dcFilter.map(value => value),
        dialnorm.map(value => value),
        drcLine.map(value => value),
        drcRf.map(value => value),
        lfeControl.map(value => value),
        lfeFilter.map(value => value),
        loRoCenterMixLevel.map(value => value),
        loRoSurroundMixLevel.map(value => value),
        ltRtCenterMixLevel.map(value => value),
        ltRtSurroundMixLevel.map(value => value),
        metadataControl.map(value => value),
        passthroughControl.map(value => value),
        phaseControl.map(value => value),
        stereoDownmix.map(value => value),
        surroundExMode.map(value => value),
        surroundMode.map(value => value)
      )
    def attenuationControl
        : Option[zio.aws.medialive.model.Eac3AttenuationControl]
    def bitrate: Option[__double]
    def bitstreamMode: Option[zio.aws.medialive.model.Eac3BitstreamMode]
    def codingMode: Option[zio.aws.medialive.model.Eac3CodingMode]
    def dcFilter: Option[zio.aws.medialive.model.Eac3DcFilter]
    def dialnorm: Option[__integerMin1Max31]
    def drcLine: Option[zio.aws.medialive.model.Eac3DrcLine]
    def drcRf: Option[zio.aws.medialive.model.Eac3DrcRf]
    def lfeControl: Option[zio.aws.medialive.model.Eac3LfeControl]
    def lfeFilter: Option[zio.aws.medialive.model.Eac3LfeFilter]
    def loRoCenterMixLevel: Option[__double]
    def loRoSurroundMixLevel: Option[__double]
    def ltRtCenterMixLevel: Option[__double]
    def ltRtSurroundMixLevel: Option[__double]
    def metadataControl: Option[zio.aws.medialive.model.Eac3MetadataControl]
    def passthroughControl
        : Option[zio.aws.medialive.model.Eac3PassthroughControl]
    def phaseControl: Option[zio.aws.medialive.model.Eac3PhaseControl]
    def stereoDownmix: Option[zio.aws.medialive.model.Eac3StereoDownmix]
    def surroundExMode: Option[zio.aws.medialive.model.Eac3SurroundExMode]
    def surroundMode: Option[zio.aws.medialive.model.Eac3SurroundMode]
    def getAttenuationControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3AttenuationControl] =
      AwsError.unwrapOptionField("attenuationControl", attenuationControl)
    def getBitrate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getBitstreamMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3BitstreamMode] =
      AwsError.unwrapOptionField("bitstreamMode", bitstreamMode)
    def getCodingMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3CodingMode] =
      AwsError.unwrapOptionField("codingMode", codingMode)
    def getDcFilter: ZIO[Any, AwsError, zio.aws.medialive.model.Eac3DcFilter] =
      AwsError.unwrapOptionField("dcFilter", dcFilter)
    def getDialnorm: ZIO[Any, AwsError, __integerMin1Max31] =
      AwsError.unwrapOptionField("dialnorm", dialnorm)
    def getDrcLine: ZIO[Any, AwsError, zio.aws.medialive.model.Eac3DrcLine] =
      AwsError.unwrapOptionField("drcLine", drcLine)
    def getDrcRf: ZIO[Any, AwsError, zio.aws.medialive.model.Eac3DrcRf] =
      AwsError.unwrapOptionField("drcRf", drcRf)
    def getLfeControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3LfeControl] =
      AwsError.unwrapOptionField("lfeControl", lfeControl)
    def getLfeFilter
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3LfeFilter] =
      AwsError.unwrapOptionField("lfeFilter", lfeFilter)
    def getLoRoCenterMixLevel: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("loRoCenterMixLevel", loRoCenterMixLevel)
    def getLoRoSurroundMixLevel: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("loRoSurroundMixLevel", loRoSurroundMixLevel)
    def getLtRtCenterMixLevel: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("ltRtCenterMixLevel", ltRtCenterMixLevel)
    def getLtRtSurroundMixLevel: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("ltRtSurroundMixLevel", ltRtSurroundMixLevel)
    def getMetadataControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3MetadataControl] =
      AwsError.unwrapOptionField("metadataControl", metadataControl)
    def getPassthroughControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3PassthroughControl] =
      AwsError.unwrapOptionField("passthroughControl", passthroughControl)
    def getPhaseControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3PhaseControl] =
      AwsError.unwrapOptionField("phaseControl", phaseControl)
    def getStereoDownmix
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3StereoDownmix] =
      AwsError.unwrapOptionField("stereoDownmix", stereoDownmix)
    def getSurroundExMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3SurroundExMode] =
      AwsError.unwrapOptionField("surroundExMode", surroundExMode)
    def getSurroundMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3SurroundMode] =
      AwsError.unwrapOptionField("surroundMode", surroundMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Eac3Settings
  ) extends zio.aws.medialive.model.Eac3Settings.ReadOnly {
    override val attenuationControl
        : Option[zio.aws.medialive.model.Eac3AttenuationControl] = scala
      .Option(impl.attenuationControl())
      .map(value => zio.aws.medialive.model.Eac3AttenuationControl.wrap(value))
    override val bitrate: Option[__double] =
      scala.Option(impl.bitrate()).map(value => value: __double)
    override val bitstreamMode
        : Option[zio.aws.medialive.model.Eac3BitstreamMode] = scala
      .Option(impl.bitstreamMode())
      .map(value => zio.aws.medialive.model.Eac3BitstreamMode.wrap(value))
    override val codingMode: Option[zio.aws.medialive.model.Eac3CodingMode] =
      scala
        .Option(impl.codingMode())
        .map(value => zio.aws.medialive.model.Eac3CodingMode.wrap(value))
    override val dcFilter: Option[zio.aws.medialive.model.Eac3DcFilter] = scala
      .Option(impl.dcFilter())
      .map(value => zio.aws.medialive.model.Eac3DcFilter.wrap(value))
    override val dialnorm: Option[__integerMin1Max31] =
      scala.Option(impl.dialnorm()).map(value => value: __integerMin1Max31)
    override val drcLine: Option[zio.aws.medialive.model.Eac3DrcLine] = scala
      .Option(impl.drcLine())
      .map(value => zio.aws.medialive.model.Eac3DrcLine.wrap(value))
    override val drcRf: Option[zio.aws.medialive.model.Eac3DrcRf] = scala
      .Option(impl.drcRf())
      .map(value => zio.aws.medialive.model.Eac3DrcRf.wrap(value))
    override val lfeControl: Option[zio.aws.medialive.model.Eac3LfeControl] =
      scala
        .Option(impl.lfeControl())
        .map(value => zio.aws.medialive.model.Eac3LfeControl.wrap(value))
    override val lfeFilter: Option[zio.aws.medialive.model.Eac3LfeFilter] =
      scala
        .Option(impl.lfeFilter())
        .map(value => zio.aws.medialive.model.Eac3LfeFilter.wrap(value))
    override val loRoCenterMixLevel: Option[__double] =
      scala.Option(impl.loRoCenterMixLevel()).map(value => value: __double)
    override val loRoSurroundMixLevel: Option[__double] =
      scala.Option(impl.loRoSurroundMixLevel()).map(value => value: __double)
    override val ltRtCenterMixLevel: Option[__double] =
      scala.Option(impl.ltRtCenterMixLevel()).map(value => value: __double)
    override val ltRtSurroundMixLevel: Option[__double] =
      scala.Option(impl.ltRtSurroundMixLevel()).map(value => value: __double)
    override val metadataControl
        : Option[zio.aws.medialive.model.Eac3MetadataControl] = scala
      .Option(impl.metadataControl())
      .map(value => zio.aws.medialive.model.Eac3MetadataControl.wrap(value))
    override val passthroughControl
        : Option[zio.aws.medialive.model.Eac3PassthroughControl] = scala
      .Option(impl.passthroughControl())
      .map(value => zio.aws.medialive.model.Eac3PassthroughControl.wrap(value))
    override val phaseControl
        : Option[zio.aws.medialive.model.Eac3PhaseControl] = scala
      .Option(impl.phaseControl())
      .map(value => zio.aws.medialive.model.Eac3PhaseControl.wrap(value))
    override val stereoDownmix
        : Option[zio.aws.medialive.model.Eac3StereoDownmix] = scala
      .Option(impl.stereoDownmix())
      .map(value => zio.aws.medialive.model.Eac3StereoDownmix.wrap(value))
    override val surroundExMode
        : Option[zio.aws.medialive.model.Eac3SurroundExMode] = scala
      .Option(impl.surroundExMode())
      .map(value => zio.aws.medialive.model.Eac3SurroundExMode.wrap(value))
    override val surroundMode
        : Option[zio.aws.medialive.model.Eac3SurroundMode] = scala
      .Option(impl.surroundMode())
      .map(value => zio.aws.medialive.model.Eac3SurroundMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Eac3Settings
  ): zio.aws.medialive.model.Eac3Settings.ReadOnly = new Wrapper(impl)
}
