package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3StereoDownmix {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix
}
object Eac3StereoDownmix {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix
  ): zio.aws.medialive.model.Eac3StereoDownmix = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.DPL2 =>
      val r = DPL2
      r
    case software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.LO_RO =>
      val r = LO_RO
      r
    case software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.LT_RT =>
      val r = LT_RT
      r
    case software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.NOT_INDICATED =>
      val r = NOT_INDICATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3StereoDownmix {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix =
      software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.UNKNOWN_TO_SDK_VERSION
  }
  case object DPL2 extends zio.aws.medialive.model.Eac3StereoDownmix {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix =
      software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.DPL2
  }
  case object LO_RO extends zio.aws.medialive.model.Eac3StereoDownmix {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix =
      software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.LO_RO
  }
  case object LT_RT extends zio.aws.medialive.model.Eac3StereoDownmix {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix =
      software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.LT_RT
  }
  case object NOT_INDICATED extends zio.aws.medialive.model.Eac3StereoDownmix {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix =
      software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix.NOT_INDICATED
  }
}
