package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3SurroundExMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode
}
object Eac3SurroundExMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode
  ): zio.aws.medialive.model.Eac3SurroundExMode = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.NOT_INDICATED =>
      val r = NOT_INDICATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3SurroundExMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.Eac3SurroundExMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.Eac3SurroundExMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.ENABLED
  }
  case object NOT_INDICATED extends zio.aws.medialive.model.Eac3SurroundExMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode.NOT_INDICATED
  }
}
