package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Eac3SurroundMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Eac3SurroundMode
}
object Eac3SurroundMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Eac3SurroundMode
  ): zio.aws.medialive.model.Eac3SurroundMode = value match {
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.NOT_INDICATED =>
      val r = NOT_INDICATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Eac3SurroundMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.Eac3SurroundMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.Eac3SurroundMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.ENABLED
  }
  case object NOT_INDICATED extends zio.aws.medialive.model.Eac3SurroundMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Eac3SurroundMode =
      software.amazon.awssdk.services.medialive.model.Eac3SurroundMode.NOT_INDICATED
  }
}
