package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, __stringMax1000}
import scala.jdk.CollectionConverters._
final case class EbuTtDDestinationSettings(
    copyrightHolder: Option[__stringMax1000] = None,
    fillLineGap: Option[zio.aws.medialive.model.EbuTtDFillLineGapControl] =
      None,
    fontFamily: Option[__string] = None,
    styleControl: Option[
      zio.aws.medialive.model.EbuTtDDestinationStyleControl
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.EbuTtDDestinationSettings = {
    import EbuTtDDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.EbuTtDDestinationSettings
      .builder()
      .optionallyWith(copyrightHolder.map(value => value: java.lang.String))(
        _.copyrightHolder
      )
      .optionallyWith(fillLineGap.map(value => value.unwrap))(_.fillLineGap)
      .optionallyWith(fontFamily.map(value => value: java.lang.String))(
        _.fontFamily
      )
      .optionallyWith(styleControl.map(value => value.unwrap))(_.styleControl)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.EbuTtDDestinationSettings.ReadOnly =
    zio.aws.medialive.model.EbuTtDDestinationSettings.wrap(buildAwsValue())
}
object EbuTtDDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.EbuTtDDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.EbuTtDDestinationSettings =
      zio.aws.medialive.model.EbuTtDDestinationSettings(
        copyrightHolder.map(value => value),
        fillLineGap.map(value => value),
        fontFamily.map(value => value),
        styleControl.map(value => value)
      )
    def copyrightHolder: Option[__stringMax1000]
    def fillLineGap: Option[zio.aws.medialive.model.EbuTtDFillLineGapControl]
    def fontFamily: Option[__string]
    def styleControl
        : Option[zio.aws.medialive.model.EbuTtDDestinationStyleControl]
    def getCopyrightHolder: ZIO[Any, AwsError, __stringMax1000] =
      AwsError.unwrapOptionField("copyrightHolder", copyrightHolder)
    def getFillLineGap
        : ZIO[Any, AwsError, zio.aws.medialive.model.EbuTtDFillLineGapControl] =
      AwsError.unwrapOptionField("fillLineGap", fillLineGap)
    def getFontFamily: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fontFamily", fontFamily)
    def getStyleControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.EbuTtDDestinationStyleControl
    ] = AwsError.unwrapOptionField("styleControl", styleControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.EbuTtDDestinationSettings
  ) extends zio.aws.medialive.model.EbuTtDDestinationSettings.ReadOnly {
    override val copyrightHolder: Option[__stringMax1000] =
      scala.Option(impl.copyrightHolder()).map(value => value: __stringMax1000)
    override val fillLineGap
        : Option[zio.aws.medialive.model.EbuTtDFillLineGapControl] = scala
      .Option(impl.fillLineGap())
      .map(value =>
        zio.aws.medialive.model.EbuTtDFillLineGapControl.wrap(value)
      )
    override val fontFamily: Option[__string] =
      scala.Option(impl.fontFamily()).map(value => value: __string)
    override val styleControl
        : Option[zio.aws.medialive.model.EbuTtDDestinationStyleControl] = scala
      .Option(impl.styleControl())
      .map(value =>
        zio.aws.medialive.model.EbuTtDDestinationStyleControl.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.EbuTtDDestinationSettings
  ): zio.aws.medialive.model.EbuTtDDestinationSettings.ReadOnly = new Wrapper(
    impl
  )
}
