package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait EmbeddedScte20Detection {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection
}
object EmbeddedScte20Detection {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection
  ): zio.aws.medialive.model.EmbeddedScte20Detection = value match {
    case software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.EmbeddedScte20Detection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection =
      software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.EmbeddedScte20Detection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection =
      software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection.AUTO
  }
  case object OFF extends zio.aws.medialive.model.EmbeddedScte20Detection {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection =
      software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection.OFF
  }
}
