package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin1Max5, __integerMin1Max4}
import scala.jdk.CollectionConverters._
final case class EmbeddedSourceSettings(
    convert608To708: Option[zio.aws.medialive.model.EmbeddedConvert608To708] =
      None,
    scte20Detection: Option[zio.aws.medialive.model.EmbeddedScte20Detection] =
      None,
    source608ChannelNumber: Option[__integerMin1Max4] = None,
    source608TrackNumber: Option[__integerMin1Max5] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings = {
    import EmbeddedSourceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings
      .builder()
      .optionallyWith(convert608To708.map(value => value.unwrap))(
        _.convert608To708
      )
      .optionallyWith(scte20Detection.map(value => value.unwrap))(
        _.scte20Detection
      )
      .optionallyWith(source608ChannelNumber.map(value => value: Integer))(
        _.source608ChannelNumber
      )
      .optionallyWith(source608TrackNumber.map(value => value: Integer))(
        _.source608TrackNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.EmbeddedSourceSettings.ReadOnly =
    zio.aws.medialive.model.EmbeddedSourceSettings.wrap(buildAwsValue())
}
object EmbeddedSourceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.EmbeddedSourceSettings =
      zio.aws.medialive.model.EmbeddedSourceSettings(
        convert608To708.map(value => value),
        scte20Detection.map(value => value),
        source608ChannelNumber.map(value => value),
        source608TrackNumber.map(value => value)
      )
    def convert608To708: Option[zio.aws.medialive.model.EmbeddedConvert608To708]
    def scte20Detection: Option[zio.aws.medialive.model.EmbeddedScte20Detection]
    def source608ChannelNumber: Option[__integerMin1Max4]
    def source608TrackNumber: Option[__integerMin1Max5]
    def getConvert608To708
        : ZIO[Any, AwsError, zio.aws.medialive.model.EmbeddedConvert608To708] =
      AwsError.unwrapOptionField("convert608To708", convert608To708)
    def getScte20Detection
        : ZIO[Any, AwsError, zio.aws.medialive.model.EmbeddedScte20Detection] =
      AwsError.unwrapOptionField("scte20Detection", scte20Detection)
    def getSource608ChannelNumber: ZIO[Any, AwsError, __integerMin1Max4] =
      AwsError.unwrapOptionField(
        "source608ChannelNumber",
        source608ChannelNumber
      )
    def getSource608TrackNumber: ZIO[Any, AwsError, __integerMin1Max5] =
      AwsError.unwrapOptionField("source608TrackNumber", source608TrackNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings
  ) extends zio.aws.medialive.model.EmbeddedSourceSettings.ReadOnly {
    override val convert608To708
        : Option[zio.aws.medialive.model.EmbeddedConvert608To708] = scala
      .Option(impl.convert608To708())
      .map(value => zio.aws.medialive.model.EmbeddedConvert608To708.wrap(value))
    override val scte20Detection
        : Option[zio.aws.medialive.model.EmbeddedScte20Detection] = scala
      .Option(impl.scte20Detection())
      .map(value => zio.aws.medialive.model.EmbeddedScte20Detection.wrap(value))
    override val source608ChannelNumber: Option[__integerMin1Max4] = scala
      .Option(impl.source608ChannelNumber())
      .map(value => value: __integerMin1Max4)
    override val source608TrackNumber: Option[__integerMin1Max5] = scala
      .Option(impl.source608TrackNumber())
      .map(value => value: __integerMin1Max5)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings
  ): zio.aws.medialive.model.EmbeddedSourceSettings.ReadOnly = new Wrapper(impl)
}
