package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EncoderSettings(
    audioDescriptions: Iterable[zio.aws.medialive.model.AudioDescription],
    availBlanking: Option[zio.aws.medialive.model.AvailBlanking] = None,
    availConfiguration: Option[zio.aws.medialive.model.AvailConfiguration] =
      None,
    blackoutSlate: Option[zio.aws.medialive.model.BlackoutSlate] = None,
    captionDescriptions: Option[
      Iterable[zio.aws.medialive.model.CaptionDescription]
    ] = None,
    featureActivations: Option[zio.aws.medialive.model.FeatureActivations] =
      None,
    globalConfiguration: Option[zio.aws.medialive.model.GlobalConfiguration] =
      None,
    motionGraphicsConfiguration: Option[
      zio.aws.medialive.model.MotionGraphicsConfiguration
    ] = None,
    nielsenConfiguration: Option[zio.aws.medialive.model.NielsenConfiguration] =
      None,
    outputGroups: Iterable[zio.aws.medialive.model.OutputGroup],
    timecodeConfig: zio.aws.medialive.model.TimecodeConfig,
    videoDescriptions: Iterable[zio.aws.medialive.model.VideoDescription]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.EncoderSettings = {
    import EncoderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.EncoderSettings
      .builder()
      .audioDescriptions(audioDescriptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(availBlanking.map(value => value.buildAwsValue()))(
        _.availBlanking
      )
      .optionallyWith(availConfiguration.map(value => value.buildAwsValue()))(
        _.availConfiguration
      )
      .optionallyWith(blackoutSlate.map(value => value.buildAwsValue()))(
        _.blackoutSlate
      )
      .optionallyWith(
        captionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.captionDescriptions)
      .optionallyWith(featureActivations.map(value => value.buildAwsValue()))(
        _.featureActivations
      )
      .optionallyWith(globalConfiguration.map(value => value.buildAwsValue()))(
        _.globalConfiguration
      )
      .optionallyWith(
        motionGraphicsConfiguration.map(value => value.buildAwsValue())
      )(_.motionGraphicsConfiguration)
      .optionallyWith(nielsenConfiguration.map(value => value.buildAwsValue()))(
        _.nielsenConfiguration
      )
      .outputGroups(outputGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .timecodeConfig(timecodeConfig.buildAwsValue())
      .videoDescriptions(videoDescriptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.EncoderSettings.ReadOnly =
    zio.aws.medialive.model.EncoderSettings.wrap(buildAwsValue())
}
object EncoderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.EncoderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.EncoderSettings =
      zio.aws.medialive.model.EncoderSettings(
        audioDescriptions.map { item =>
          item.asEditable
        },
        availBlanking.map(value => value.asEditable),
        availConfiguration.map(value => value.asEditable),
        blackoutSlate.map(value => value.asEditable),
        captionDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        featureActivations.map(value => value.asEditable),
        globalConfiguration.map(value => value.asEditable),
        motionGraphicsConfiguration.map(value => value.asEditable),
        nielsenConfiguration.map(value => value.asEditable),
        outputGroups.map { item =>
          item.asEditable
        },
        timecodeConfig.asEditable,
        videoDescriptions.map { item =>
          item.asEditable
        }
      )
    def audioDescriptions
        : List[zio.aws.medialive.model.AudioDescription.ReadOnly]
    def availBlanking: Option[zio.aws.medialive.model.AvailBlanking.ReadOnly]
    def availConfiguration
        : Option[zio.aws.medialive.model.AvailConfiguration.ReadOnly]
    def blackoutSlate: Option[zio.aws.medialive.model.BlackoutSlate.ReadOnly]
    def captionDescriptions
        : Option[List[zio.aws.medialive.model.CaptionDescription.ReadOnly]]
    def featureActivations
        : Option[zio.aws.medialive.model.FeatureActivations.ReadOnly]
    def globalConfiguration
        : Option[zio.aws.medialive.model.GlobalConfiguration.ReadOnly]
    def motionGraphicsConfiguration
        : Option[zio.aws.medialive.model.MotionGraphicsConfiguration.ReadOnly]
    def nielsenConfiguration
        : Option[zio.aws.medialive.model.NielsenConfiguration.ReadOnly]
    def outputGroups: List[zio.aws.medialive.model.OutputGroup.ReadOnly]
    def timecodeConfig: zio.aws.medialive.model.TimecodeConfig.ReadOnly
    def videoDescriptions
        : List[zio.aws.medialive.model.VideoDescription.ReadOnly]
    def getAudioDescriptions: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.AudioDescription.ReadOnly
    ]] = ZIO.succeed(audioDescriptions)
    def getAvailBlanking
        : ZIO[Any, AwsError, zio.aws.medialive.model.AvailBlanking.ReadOnly] =
      AwsError.unwrapOptionField("availBlanking", availBlanking)
    def getAvailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AvailConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("availConfiguration", availConfiguration)
    def getBlackoutSlate
        : ZIO[Any, AwsError, zio.aws.medialive.model.BlackoutSlate.ReadOnly] =
      AwsError.unwrapOptionField("blackoutSlate", blackoutSlate)
    def getCaptionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.CaptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("captionDescriptions", captionDescriptions)
    def getFeatureActivations: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FeatureActivations.ReadOnly
    ] = AwsError.unwrapOptionField("featureActivations", featureActivations)
    def getGlobalConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.GlobalConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("globalConfiguration", globalConfiguration)
    def getMotionGraphicsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MotionGraphicsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "motionGraphicsConfiguration",
      motionGraphicsConfiguration
    )
    def getNielsenConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.NielsenConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("nielsenConfiguration", nielsenConfiguration)
    def getOutputGroups: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.OutputGroup.ReadOnly
    ]] = ZIO.succeed(outputGroups)
    def getTimecodeConfig
        : ZIO[Any, Nothing, zio.aws.medialive.model.TimecodeConfig.ReadOnly] =
      ZIO.succeed(timecodeConfig)
    def getVideoDescriptions: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.VideoDescription.ReadOnly
    ]] = ZIO.succeed(videoDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.EncoderSettings
  ) extends zio.aws.medialive.model.EncoderSettings.ReadOnly {
    override val audioDescriptions
        : List[zio.aws.medialive.model.AudioDescription.ReadOnly] = impl
      .audioDescriptions()
      .asScala
      .map { item =>
        zio.aws.medialive.model.AudioDescription.wrap(item)
      }
      .toList
    override val availBlanking
        : Option[zio.aws.medialive.model.AvailBlanking.ReadOnly] = scala
      .Option(impl.availBlanking())
      .map(value => zio.aws.medialive.model.AvailBlanking.wrap(value))
    override val availConfiguration
        : Option[zio.aws.medialive.model.AvailConfiguration.ReadOnly] = scala
      .Option(impl.availConfiguration())
      .map(value => zio.aws.medialive.model.AvailConfiguration.wrap(value))
    override val blackoutSlate
        : Option[zio.aws.medialive.model.BlackoutSlate.ReadOnly] = scala
      .Option(impl.blackoutSlate())
      .map(value => zio.aws.medialive.model.BlackoutSlate.wrap(value))
    override val captionDescriptions
        : Option[List[zio.aws.medialive.model.CaptionDescription.ReadOnly]] =
      scala
        .Option(impl.captionDescriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.CaptionDescription.wrap(item)
          }.toList
        )
    override val featureActivations
        : Option[zio.aws.medialive.model.FeatureActivations.ReadOnly] = scala
      .Option(impl.featureActivations())
      .map(value => zio.aws.medialive.model.FeatureActivations.wrap(value))
    override val globalConfiguration
        : Option[zio.aws.medialive.model.GlobalConfiguration.ReadOnly] = scala
      .Option(impl.globalConfiguration())
      .map(value => zio.aws.medialive.model.GlobalConfiguration.wrap(value))
    override val motionGraphicsConfiguration
        : Option[zio.aws.medialive.model.MotionGraphicsConfiguration.ReadOnly] =
      scala
        .Option(impl.motionGraphicsConfiguration())
        .map(value =>
          zio.aws.medialive.model.MotionGraphicsConfiguration.wrap(value)
        )
    override val nielsenConfiguration
        : Option[zio.aws.medialive.model.NielsenConfiguration.ReadOnly] = scala
      .Option(impl.nielsenConfiguration())
      .map(value => zio.aws.medialive.model.NielsenConfiguration.wrap(value))
    override val outputGroups
        : List[zio.aws.medialive.model.OutputGroup.ReadOnly] = impl
      .outputGroups()
      .asScala
      .map { item =>
        zio.aws.medialive.model.OutputGroup.wrap(item)
      }
      .toList
    override val timecodeConfig
        : zio.aws.medialive.model.TimecodeConfig.ReadOnly =
      zio.aws.medialive.model.TimecodeConfig.wrap(impl.timecodeConfig())
    override val videoDescriptions
        : List[zio.aws.medialive.model.VideoDescription.ReadOnly] = impl
      .videoDescriptions()
      .asScala
      .map { item =>
        zio.aws.medialive.model.VideoDescription.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.EncoderSettings
  ): zio.aws.medialive.model.EncoderSettings.ReadOnly = new Wrapper(impl)
}
