package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailoverCondition(
    failoverConditionSettings: Option[
      zio.aws.medialive.model.FailoverConditionSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FailoverCondition = {
    import FailoverCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FailoverCondition
      .builder()
      .optionallyWith(
        failoverConditionSettings.map(value => value.buildAwsValue())
      )(_.failoverConditionSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FailoverCondition.ReadOnly =
    zio.aws.medialive.model.FailoverCondition.wrap(buildAwsValue())
}
object FailoverCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FailoverCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FailoverCondition =
      zio.aws.medialive.model.FailoverCondition(
        failoverConditionSettings.map(value => value.asEditable)
      )
    def failoverConditionSettings
        : Option[zio.aws.medialive.model.FailoverConditionSettings.ReadOnly]
    def getFailoverConditionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FailoverConditionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "failoverConditionSettings",
      failoverConditionSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FailoverCondition
  ) extends zio.aws.medialive.model.FailoverCondition.ReadOnly {
    override val failoverConditionSettings
        : Option[zio.aws.medialive.model.FailoverConditionSettings.ReadOnly] =
      scala
        .Option(impl.failoverConditionSettings())
        .map(value =>
          zio.aws.medialive.model.FailoverConditionSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FailoverCondition
  ): zio.aws.medialive.model.FailoverCondition.ReadOnly = new Wrapper(impl)
}
