package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailoverConditionSettings(
    audioSilenceSettings: Option[
      zio.aws.medialive.model.AudioSilenceFailoverSettings
    ] = None,
    inputLossSettings: Option[
      zio.aws.medialive.model.InputLossFailoverSettings
    ] = None,
    videoBlackSettings: Option[
      zio.aws.medialive.model.VideoBlackFailoverSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FailoverConditionSettings = {
    import FailoverConditionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FailoverConditionSettings
      .builder()
      .optionallyWith(audioSilenceSettings.map(value => value.buildAwsValue()))(
        _.audioSilenceSettings
      )
      .optionallyWith(inputLossSettings.map(value => value.buildAwsValue()))(
        _.inputLossSettings
      )
      .optionallyWith(videoBlackSettings.map(value => value.buildAwsValue()))(
        _.videoBlackSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FailoverConditionSettings.ReadOnly =
    zio.aws.medialive.model.FailoverConditionSettings.wrap(buildAwsValue())
}
object FailoverConditionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FailoverConditionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FailoverConditionSettings =
      zio.aws.medialive.model.FailoverConditionSettings(
        audioSilenceSettings.map(value => value.asEditable),
        inputLossSettings.map(value => value.asEditable),
        videoBlackSettings.map(value => value.asEditable)
      )
    def audioSilenceSettings
        : Option[zio.aws.medialive.model.AudioSilenceFailoverSettings.ReadOnly]
    def inputLossSettings
        : Option[zio.aws.medialive.model.InputLossFailoverSettings.ReadOnly]
    def videoBlackSettings
        : Option[zio.aws.medialive.model.VideoBlackFailoverSettings.ReadOnly]
    def getAudioSilenceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioSilenceFailoverSettings.ReadOnly
    ] = AwsError.unwrapOptionField("audioSilenceSettings", audioSilenceSettings)
    def getInputLossSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputLossFailoverSettings.ReadOnly
    ] = AwsError.unwrapOptionField("inputLossSettings", inputLossSettings)
    def getVideoBlackSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.VideoBlackFailoverSettings.ReadOnly
    ] = AwsError.unwrapOptionField("videoBlackSettings", videoBlackSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FailoverConditionSettings
  ) extends zio.aws.medialive.model.FailoverConditionSettings.ReadOnly {
    override val audioSilenceSettings: Option[
      zio.aws.medialive.model.AudioSilenceFailoverSettings.ReadOnly
    ] = scala
      .Option(impl.audioSilenceSettings())
      .map(value =>
        zio.aws.medialive.model.AudioSilenceFailoverSettings.wrap(value)
      )
    override val inputLossSettings
        : Option[zio.aws.medialive.model.InputLossFailoverSettings.ReadOnly] =
      scala
        .Option(impl.inputLossSettings())
        .map(value =>
          zio.aws.medialive.model.InputLossFailoverSettings.wrap(value)
        )
    override val videoBlackSettings
        : Option[zio.aws.medialive.model.VideoBlackFailoverSettings.ReadOnly] =
      scala
        .Option(impl.videoBlackSettings())
        .map(value =>
          zio.aws.medialive.model.VideoBlackFailoverSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FailoverConditionSettings
  ): zio.aws.medialive.model.FailoverConditionSettings.ReadOnly = new Wrapper(
    impl
  )
}
