package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FeatureActivations(
    inputPrepareScheduleActions: Option[
      zio.aws.medialive.model.FeatureActivationsInputPrepareScheduleActions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FeatureActivations = {
    import FeatureActivations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FeatureActivations
      .builder()
      .optionallyWith(inputPrepareScheduleActions.map(value => value.unwrap))(
        _.inputPrepareScheduleActions
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FeatureActivations.ReadOnly =
    zio.aws.medialive.model.FeatureActivations.wrap(buildAwsValue())
}
object FeatureActivations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FeatureActivations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FeatureActivations =
      zio.aws.medialive.model
        .FeatureActivations(inputPrepareScheduleActions.map(value => value))
    def inputPrepareScheduleActions: Option[
      zio.aws.medialive.model.FeatureActivationsInputPrepareScheduleActions
    ]
    def getInputPrepareScheduleActions: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FeatureActivationsInputPrepareScheduleActions
    ] = AwsError.unwrapOptionField(
      "inputPrepareScheduleActions",
      inputPrepareScheduleActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FeatureActivations
  ) extends zio.aws.medialive.model.FeatureActivations.ReadOnly {
    override val inputPrepareScheduleActions: Option[
      zio.aws.medialive.model.FeatureActivationsInputPrepareScheduleActions
    ] = scala
      .Option(impl.inputPrepareScheduleActions())
      .map(value =>
        zio.aws.medialive.model.FeatureActivationsInputPrepareScheduleActions
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FeatureActivations
  ): zio.aws.medialive.model.FeatureActivations.ReadOnly = new Wrapper(impl)
}
