package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin1Max20,
  __integerMin4Max20
}
import scala.jdk.CollectionConverters._
final case class FecOutputSettings(
    columnDepth: Option[__integerMin4Max20] = None,
    includeFec: Option[zio.aws.medialive.model.FecOutputIncludeFec] = None,
    rowLength: Option[__integerMin1Max20] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FecOutputSettings = {
    import FecOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FecOutputSettings
      .builder()
      .optionallyWith(columnDepth.map(value => value: Integer))(_.columnDepth)
      .optionallyWith(includeFec.map(value => value.unwrap))(_.includeFec)
      .optionallyWith(rowLength.map(value => value: Integer))(_.rowLength)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FecOutputSettings.ReadOnly =
    zio.aws.medialive.model.FecOutputSettings.wrap(buildAwsValue())
}
object FecOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FecOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FecOutputSettings =
      zio.aws.medialive.model.FecOutputSettings(
        columnDepth.map(value => value),
        includeFec.map(value => value),
        rowLength.map(value => value)
      )
    def columnDepth: Option[__integerMin4Max20]
    def includeFec: Option[zio.aws.medialive.model.FecOutputIncludeFec]
    def rowLength: Option[__integerMin1Max20]
    def getColumnDepth: ZIO[Any, AwsError, __integerMin4Max20] =
      AwsError.unwrapOptionField("columnDepth", columnDepth)
    def getIncludeFec
        : ZIO[Any, AwsError, zio.aws.medialive.model.FecOutputIncludeFec] =
      AwsError.unwrapOptionField("includeFec", includeFec)
    def getRowLength: ZIO[Any, AwsError, __integerMin1Max20] =
      AwsError.unwrapOptionField("rowLength", rowLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FecOutputSettings
  ) extends zio.aws.medialive.model.FecOutputSettings.ReadOnly {
    override val columnDepth: Option[__integerMin4Max20] =
      scala.Option(impl.columnDepth()).map(value => value: __integerMin4Max20)
    override val includeFec
        : Option[zio.aws.medialive.model.FecOutputIncludeFec] = scala
      .Option(impl.includeFec())
      .map(value => zio.aws.medialive.model.FecOutputIncludeFec.wrap(value))
    override val rowLength: Option[__integerMin1Max20] =
      scala.Option(impl.rowLength()).map(value => value: __integerMin1Max20)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FecOutputSettings
  ): zio.aws.medialive.model.FecOutputSettings.ReadOnly = new Wrapper(impl)
}
