package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class Fmp4HlsSettings(
    audioRenditionSets: Option[__string] = None,
    nielsenId3Behavior: Option[zio.aws.medialive.model.Fmp4NielsenId3Behavior] =
      None,
    timedMetadataBehavior: Option[
      zio.aws.medialive.model.Fmp4TimedMetadataBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Fmp4HlsSettings = {
    import Fmp4HlsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Fmp4HlsSettings
      .builder()
      .optionallyWith(audioRenditionSets.map(value => value: java.lang.String))(
        _.audioRenditionSets
      )
      .optionallyWith(nielsenId3Behavior.map(value => value.unwrap))(
        _.nielsenId3Behavior
      )
      .optionallyWith(timedMetadataBehavior.map(value => value.unwrap))(
        _.timedMetadataBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Fmp4HlsSettings.ReadOnly =
    zio.aws.medialive.model.Fmp4HlsSettings.wrap(buildAwsValue())
}
object Fmp4HlsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Fmp4HlsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Fmp4HlsSettings =
      zio.aws.medialive.model.Fmp4HlsSettings(
        audioRenditionSets.map(value => value),
        nielsenId3Behavior.map(value => value),
        timedMetadataBehavior.map(value => value)
      )
    def audioRenditionSets: Option[__string]
    def nielsenId3Behavior
        : Option[zio.aws.medialive.model.Fmp4NielsenId3Behavior]
    def timedMetadataBehavior
        : Option[zio.aws.medialive.model.Fmp4TimedMetadataBehavior]
    def getAudioRenditionSets: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("audioRenditionSets", audioRenditionSets)
    def getNielsenId3Behavior
        : ZIO[Any, AwsError, zio.aws.medialive.model.Fmp4NielsenId3Behavior] =
      AwsError.unwrapOptionField("nielsenId3Behavior", nielsenId3Behavior)
    def getTimedMetadataBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Fmp4TimedMetadataBehavior
    ] =
      AwsError.unwrapOptionField("timedMetadataBehavior", timedMetadataBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Fmp4HlsSettings
  ) extends zio.aws.medialive.model.Fmp4HlsSettings.ReadOnly {
    override val audioRenditionSets: Option[__string] =
      scala.Option(impl.audioRenditionSets()).map(value => value: __string)
    override val nielsenId3Behavior
        : Option[zio.aws.medialive.model.Fmp4NielsenId3Behavior] = scala
      .Option(impl.nielsenId3Behavior())
      .map(value => zio.aws.medialive.model.Fmp4NielsenId3Behavior.wrap(value))
    override val timedMetadataBehavior
        : Option[zio.aws.medialive.model.Fmp4TimedMetadataBehavior] = scala
      .Option(impl.timedMetadataBehavior())
      .map(value =>
        zio.aws.medialive.model.Fmp4TimedMetadataBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Fmp4HlsSettings
  ): zio.aws.medialive.model.Fmp4HlsSettings.ReadOnly = new Wrapper(impl)
}
