package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FrameCaptureCdnSettings(
    frameCaptureS3Settings: Option[
      zio.aws.medialive.model.FrameCaptureS3Settings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FrameCaptureCdnSettings = {
    import FrameCaptureCdnSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FrameCaptureCdnSettings
      .builder()
      .optionallyWith(
        frameCaptureS3Settings.map(value => value.buildAwsValue())
      )(_.frameCaptureS3Settings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FrameCaptureCdnSettings.ReadOnly =
    zio.aws.medialive.model.FrameCaptureCdnSettings.wrap(buildAwsValue())
}
object FrameCaptureCdnSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FrameCaptureCdnSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FrameCaptureCdnSettings =
      zio.aws.medialive.model.FrameCaptureCdnSettings(
        frameCaptureS3Settings.map(value => value.asEditable)
      )
    def frameCaptureS3Settings
        : Option[zio.aws.medialive.model.FrameCaptureS3Settings.ReadOnly]
    def getFrameCaptureS3Settings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FrameCaptureS3Settings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "frameCaptureS3Settings",
      frameCaptureS3Settings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureCdnSettings
  ) extends zio.aws.medialive.model.FrameCaptureCdnSettings.ReadOnly {
    override val frameCaptureS3Settings
        : Option[zio.aws.medialive.model.FrameCaptureS3Settings.ReadOnly] =
      scala
        .Option(impl.frameCaptureS3Settings())
        .map(value =>
          zio.aws.medialive.model.FrameCaptureS3Settings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureCdnSettings
  ): zio.aws.medialive.model.FrameCaptureCdnSettings.ReadOnly = new Wrapper(
    impl
  )
}
