package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FrameCaptureGroupSettings(
    destination: zio.aws.medialive.model.OutputLocationRef,
    frameCaptureCdnSettings: Option[
      zio.aws.medialive.model.FrameCaptureCdnSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FrameCaptureGroupSettings = {
    import FrameCaptureGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FrameCaptureGroupSettings
      .builder()
      .destination(destination.buildAwsValue())
      .optionallyWith(
        frameCaptureCdnSettings.map(value => value.buildAwsValue())
      )(_.frameCaptureCdnSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FrameCaptureGroupSettings.ReadOnly =
    zio.aws.medialive.model.FrameCaptureGroupSettings.wrap(buildAwsValue())
}
object FrameCaptureGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FrameCaptureGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FrameCaptureGroupSettings =
      zio.aws.medialive.model.FrameCaptureGroupSettings(
        destination.asEditable,
        frameCaptureCdnSettings.map(value => value.asEditable)
      )
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def frameCaptureCdnSettings
        : Option[zio.aws.medialive.model.FrameCaptureCdnSettings.ReadOnly]
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
    def getFrameCaptureCdnSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.FrameCaptureCdnSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "frameCaptureCdnSettings",
      frameCaptureCdnSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureGroupSettings
  ) extends zio.aws.medialive.model.FrameCaptureGroupSettings.ReadOnly {
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
    override val frameCaptureCdnSettings
        : Option[zio.aws.medialive.model.FrameCaptureCdnSettings.ReadOnly] =
      scala
        .Option(impl.frameCaptureCdnSettings())
        .map(value =>
          zio.aws.medialive.model.FrameCaptureCdnSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureGroupSettings
  ): zio.aws.medialive.model.FrameCaptureGroupSettings.ReadOnly = new Wrapper(
    impl
  )
}
