package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait FrameCaptureIntervalUnit {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit
}
object FrameCaptureIntervalUnit {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit
  ): zio.aws.medialive.model.FrameCaptureIntervalUnit = value match {
    case software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit.MILLISECONDS =>
      val r = MILLISECONDS
      r
    case software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit.SECONDS =>
      val r = SECONDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.FrameCaptureIntervalUnit {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit =
      software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object MILLISECONDS
      extends zio.aws.medialive.model.FrameCaptureIntervalUnit {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit =
      software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit.MILLISECONDS
  }
  case object SECONDS extends zio.aws.medialive.model.FrameCaptureIntervalUnit {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit =
      software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit.SECONDS
  }
}
