package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class FrameCaptureOutputSettings(
    nameModifier: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings = {
    import FrameCaptureOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings
      .builder()
      .optionallyWith(nameModifier.map(value => value: java.lang.String))(
        _.nameModifier
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FrameCaptureOutputSettings.ReadOnly =
    zio.aws.medialive.model.FrameCaptureOutputSettings.wrap(buildAwsValue())
}
object FrameCaptureOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FrameCaptureOutputSettings =
      zio.aws.medialive.model
        .FrameCaptureOutputSettings(nameModifier.map(value => value))
    def nameModifier: Option[__string]
    def getNameModifier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nameModifier", nameModifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings
  ) extends zio.aws.medialive.model.FrameCaptureOutputSettings.ReadOnly {
    override val nameModifier: Option[__string] =
      scala.Option(impl.nameModifier()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings
  ): zio.aws.medialive.model.FrameCaptureOutputSettings.ReadOnly = new Wrapper(
    impl
  )
}
