package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1Max3600000
import scala.jdk.CollectionConverters._
final case class FrameCaptureSettings(
    captureInterval: Option[__integerMin1Max3600000] = None,
    captureIntervalUnits: Option[
      zio.aws.medialive.model.FrameCaptureIntervalUnit
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.FrameCaptureSettings = {
    import FrameCaptureSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.FrameCaptureSettings
      .builder()
      .optionallyWith(captureInterval.map(value => value: Integer))(
        _.captureInterval
      )
      .optionallyWith(captureIntervalUnits.map(value => value.unwrap))(
        _.captureIntervalUnits
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.FrameCaptureSettings.ReadOnly =
    zio.aws.medialive.model.FrameCaptureSettings.wrap(buildAwsValue())
}
object FrameCaptureSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.FrameCaptureSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.FrameCaptureSettings =
      zio.aws.medialive.model.FrameCaptureSettings(
        captureInterval.map(value => value),
        captureIntervalUnits.map(value => value)
      )
    def captureInterval: Option[__integerMin1Max3600000]
    def captureIntervalUnits
        : Option[zio.aws.medialive.model.FrameCaptureIntervalUnit]
    def getCaptureInterval: ZIO[Any, AwsError, __integerMin1Max3600000] =
      AwsError.unwrapOptionField("captureInterval", captureInterval)
    def getCaptureIntervalUnits
        : ZIO[Any, AwsError, zio.aws.medialive.model.FrameCaptureIntervalUnit] =
      AwsError.unwrapOptionField("captureIntervalUnits", captureIntervalUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureSettings
  ) extends zio.aws.medialive.model.FrameCaptureSettings.ReadOnly {
    override val captureInterval: Option[__integerMin1Max3600000] = scala
      .Option(impl.captureInterval())
      .map(value => value: __integerMin1Max3600000)
    override val captureIntervalUnits
        : Option[zio.aws.medialive.model.FrameCaptureIntervalUnit] = scala
      .Option(impl.captureIntervalUnits())
      .map(value =>
        zio.aws.medialive.model.FrameCaptureIntervalUnit.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.FrameCaptureSettings
  ): zio.aws.medialive.model.FrameCaptureSettings.ReadOnly = new Wrapper(impl)
}
