package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMinNegative60Max60
import scala.jdk.CollectionConverters._
final case class GlobalConfiguration(
    initialAudioGain: Option[__integerMinNegative60Max60] = None,
    inputEndAction: Option[
      zio.aws.medialive.model.GlobalConfigurationInputEndAction
    ] = None,
    inputLossBehavior: Option[zio.aws.medialive.model.InputLossBehavior] = None,
    outputLockingMode: Option[
      zio.aws.medialive.model.GlobalConfigurationOutputLockingMode
    ] = None,
    outputTimingSource: Option[
      zio.aws.medialive.model.GlobalConfigurationOutputTimingSource
    ] = None,
    supportLowFramerateInputs: Option[
      zio.aws.medialive.model.GlobalConfigurationLowFramerateInputs
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.GlobalConfiguration = {
    import GlobalConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.GlobalConfiguration
      .builder()
      .optionallyWith(initialAudioGain.map(value => value: Integer))(
        _.initialAudioGain
      )
      .optionallyWith(inputEndAction.map(value => value.unwrap))(
        _.inputEndAction
      )
      .optionallyWith(inputLossBehavior.map(value => value.buildAwsValue()))(
        _.inputLossBehavior
      )
      .optionallyWith(outputLockingMode.map(value => value.unwrap))(
        _.outputLockingMode
      )
      .optionallyWith(outputTimingSource.map(value => value.unwrap))(
        _.outputTimingSource
      )
      .optionallyWith(supportLowFramerateInputs.map(value => value.unwrap))(
        _.supportLowFramerateInputs
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.GlobalConfiguration.ReadOnly =
    zio.aws.medialive.model.GlobalConfiguration.wrap(buildAwsValue())
}
object GlobalConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.GlobalConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.GlobalConfiguration =
      zio.aws.medialive.model.GlobalConfiguration(
        initialAudioGain.map(value => value),
        inputEndAction.map(value => value),
        inputLossBehavior.map(value => value.asEditable),
        outputLockingMode.map(value => value),
        outputTimingSource.map(value => value),
        supportLowFramerateInputs.map(value => value)
      )
    def initialAudioGain: Option[__integerMinNegative60Max60]
    def inputEndAction
        : Option[zio.aws.medialive.model.GlobalConfigurationInputEndAction]
    def inputLossBehavior
        : Option[zio.aws.medialive.model.InputLossBehavior.ReadOnly]
    def outputLockingMode
        : Option[zio.aws.medialive.model.GlobalConfigurationOutputLockingMode]
    def outputTimingSource
        : Option[zio.aws.medialive.model.GlobalConfigurationOutputTimingSource]
    def supportLowFramerateInputs
        : Option[zio.aws.medialive.model.GlobalConfigurationLowFramerateInputs]
    def getInitialAudioGain: ZIO[Any, AwsError, __integerMinNegative60Max60] =
      AwsError.unwrapOptionField("initialAudioGain", initialAudioGain)
    def getInputEndAction: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.GlobalConfigurationInputEndAction
    ] = AwsError.unwrapOptionField("inputEndAction", inputEndAction)
    def getInputLossBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputLossBehavior.ReadOnly
    ] = AwsError.unwrapOptionField("inputLossBehavior", inputLossBehavior)
    def getOutputLockingMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.GlobalConfigurationOutputLockingMode
    ] = AwsError.unwrapOptionField("outputLockingMode", outputLockingMode)
    def getOutputTimingSource: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.GlobalConfigurationOutputTimingSource
    ] = AwsError.unwrapOptionField("outputTimingSource", outputTimingSource)
    def getSupportLowFramerateInputs: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.GlobalConfigurationLowFramerateInputs
    ] = AwsError.unwrapOptionField(
      "supportLowFramerateInputs",
      supportLowFramerateInputs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.GlobalConfiguration
  ) extends zio.aws.medialive.model.GlobalConfiguration.ReadOnly {
    override val initialAudioGain: Option[__integerMinNegative60Max60] = scala
      .Option(impl.initialAudioGain())
      .map(value => value: __integerMinNegative60Max60)
    override val inputEndAction
        : Option[zio.aws.medialive.model.GlobalConfigurationInputEndAction] =
      scala
        .Option(impl.inputEndAction())
        .map(value =>
          zio.aws.medialive.model.GlobalConfigurationInputEndAction.wrap(value)
        )
    override val inputLossBehavior
        : Option[zio.aws.medialive.model.InputLossBehavior.ReadOnly] = scala
      .Option(impl.inputLossBehavior())
      .map(value => zio.aws.medialive.model.InputLossBehavior.wrap(value))
    override val outputLockingMode
        : Option[zio.aws.medialive.model.GlobalConfigurationOutputLockingMode] =
      scala
        .Option(impl.outputLockingMode())
        .map(value =>
          zio.aws.medialive.model.GlobalConfigurationOutputLockingMode
            .wrap(value)
        )
    override val outputTimingSource: Option[
      zio.aws.medialive.model.GlobalConfigurationOutputTimingSource
    ] = scala
      .Option(impl.outputTimingSource())
      .map(value =>
        zio.aws.medialive.model.GlobalConfigurationOutputTimingSource
          .wrap(value)
      )
    override val supportLowFramerateInputs: Option[
      zio.aws.medialive.model.GlobalConfigurationLowFramerateInputs
    ] = scala
      .Option(impl.supportLowFramerateInputs())
      .map(value =>
        zio.aws.medialive.model.GlobalConfigurationLowFramerateInputs
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.GlobalConfiguration
  ): zio.aws.medialive.model.GlobalConfiguration.ReadOnly = new Wrapper(impl)
}
