package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait GlobalConfigurationInputEndAction {
  def unwrap: software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction
}
object GlobalConfigurationInputEndAction {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction
  ): zio.aws.medialive.model.GlobalConfigurationInputEndAction = value match {
    case software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction.SWITCH_AND_LOOP_INPUTS =>
      val r = SWITCH_AND_LOOP_INPUTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.GlobalConfigurationInputEndAction {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE
      extends zio.aws.medialive.model.GlobalConfigurationInputEndAction {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction.NONE
  }
  case object SWITCH_AND_LOOP_INPUTS
      extends zio.aws.medialive.model.GlobalConfigurationInputEndAction {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction.SWITCH_AND_LOOP_INPUTS
  }
}
