package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait GlobalConfigurationOutputLockingMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode
}
object GlobalConfigurationOutputLockingMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode
  ): zio.aws.medialive.model.GlobalConfigurationOutputLockingMode =
    value match {
      case software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode.EPOCH_LOCKING =>
        val r = EPOCH_LOCKING
        r
      case software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode.PIPELINE_LOCKING =>
        val r = PIPELINE_LOCKING
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.GlobalConfigurationOutputLockingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object EPOCH_LOCKING
      extends zio.aws.medialive.model.GlobalConfigurationOutputLockingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode.EPOCH_LOCKING
  }
  case object PIPELINE_LOCKING
      extends zio.aws.medialive.model.GlobalConfigurationOutputLockingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode.PIPELINE_LOCKING
  }
}
