package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait GlobalConfigurationOutputTimingSource {
  def unwrap: software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource
}
object GlobalConfigurationOutputTimingSource {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource
  ): zio.aws.medialive.model.GlobalConfigurationOutputTimingSource =
    value match {
      case software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource.INPUT_CLOCK =>
        val r = INPUT_CLOCK
        r
      case software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource.SYSTEM_CLOCK =>
        val r = SYSTEM_CLOCK
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.GlobalConfigurationOutputTimingSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource.UNKNOWN_TO_SDK_VERSION
  }
  case object INPUT_CLOCK
      extends zio.aws.medialive.model.GlobalConfigurationOutputTimingSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource.INPUT_CLOCK
  }
  case object SYSTEM_CLOCK
      extends zio.aws.medialive.model.GlobalConfigurationOutputTimingSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource =
      software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource.SYSTEM_CLOCK
  }
}
