package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264AdaptiveQuantization {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization
}
object H264AdaptiveQuantization {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization
  ): zio.aws.medialive.model.H264AdaptiveQuantization = value match {
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.HIGHER =>
      val r = HIGHER
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.MAX =>
      val r = MAX
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.AUTO
  }
  case object HIGH extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.HIGH
  }
  case object HIGHER extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.HIGHER
  }
  case object LOW extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.LOW
  }
  case object MAX extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.MAX
  }
  case object MEDIUM extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.MEDIUM
  }
  case object OFF extends zio.aws.medialive.model.H264AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization.OFF
  }
}
