package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264ColorMetadata {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264ColorMetadata
}
object H264ColorMetadata {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264ColorMetadata
  ): zio.aws.medialive.model.H264ColorMetadata = value match {
    case software.amazon.awssdk.services.medialive.model.H264ColorMetadata.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264ColorMetadata.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.medialive.model.H264ColorMetadata.INSERT =>
      val r = INSERT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ColorMetadata =
      software.amazon.awssdk.services.medialive.model.H264ColorMetadata.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORE extends zio.aws.medialive.model.H264ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ColorMetadata =
      software.amazon.awssdk.services.medialive.model.H264ColorMetadata.IGNORE
  }
  case object INSERT extends zio.aws.medialive.model.H264ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ColorMetadata =
      software.amazon.awssdk.services.medialive.model.H264ColorMetadata.INSERT
  }
}
