package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class H264ColorSpaceSettings(
    colorSpacePassthroughSettings: Option[
      zio.aws.medialive.model.ColorSpacePassthroughSettings
    ] = None,
    rec601Settings: Option[zio.aws.medialive.model.Rec601Settings] = None,
    rec709Settings: Option[zio.aws.medialive.model.Rec709Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.H264ColorSpaceSettings = {
    import H264ColorSpaceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.H264ColorSpaceSettings
      .builder()
      .optionallyWith(
        colorSpacePassthroughSettings.map(value => value.buildAwsValue())
      )(_.colorSpacePassthroughSettings)
      .optionallyWith(rec601Settings.map(value => value.buildAwsValue()))(
        _.rec601Settings
      )
      .optionallyWith(rec709Settings.map(value => value.buildAwsValue()))(
        _.rec709Settings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.H264ColorSpaceSettings.ReadOnly =
    zio.aws.medialive.model.H264ColorSpaceSettings.wrap(buildAwsValue())
}
object H264ColorSpaceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.H264ColorSpaceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.H264ColorSpaceSettings =
      zio.aws.medialive.model.H264ColorSpaceSettings(
        colorSpacePassthroughSettings.map(value => value.asEditable),
        rec601Settings.map(value => value.asEditable),
        rec709Settings.map(value => value.asEditable)
      )
    def colorSpacePassthroughSettings
        : Option[zio.aws.medialive.model.ColorSpacePassthroughSettings.ReadOnly]
    def rec601Settings: Option[zio.aws.medialive.model.Rec601Settings.ReadOnly]
    def rec709Settings: Option[zio.aws.medialive.model.Rec709Settings.ReadOnly]
    def getColorSpacePassthroughSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ColorSpacePassthroughSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "colorSpacePassthroughSettings",
      colorSpacePassthroughSettings
    )
    def getRec601Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Rec601Settings.ReadOnly] =
      AwsError.unwrapOptionField("rec601Settings", rec601Settings)
    def getRec709Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Rec709Settings.ReadOnly] =
      AwsError.unwrapOptionField("rec709Settings", rec709Settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.H264ColorSpaceSettings
  ) extends zio.aws.medialive.model.H264ColorSpaceSettings.ReadOnly {
    override val colorSpacePassthroughSettings: Option[
      zio.aws.medialive.model.ColorSpacePassthroughSettings.ReadOnly
    ] = scala
      .Option(impl.colorSpacePassthroughSettings())
      .map(value =>
        zio.aws.medialive.model.ColorSpacePassthroughSettings.wrap(value)
      )
    override val rec601Settings
        : Option[zio.aws.medialive.model.Rec601Settings.ReadOnly] = scala
      .Option(impl.rec601Settings())
      .map(value => zio.aws.medialive.model.Rec601Settings.wrap(value))
    override val rec709Settings
        : Option[zio.aws.medialive.model.Rec709Settings.ReadOnly] = scala
      .Option(impl.rec709Settings())
      .map(value => zio.aws.medialive.model.Rec709Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.H264ColorSpaceSettings
  ): zio.aws.medialive.model.H264ColorSpaceSettings.ReadOnly = new Wrapper(impl)
}
