package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264EntropyEncoding {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H264EntropyEncoding
}
object H264EntropyEncoding {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264EntropyEncoding
  ): zio.aws.medialive.model.H264EntropyEncoding = value match {
    case software.amazon.awssdk.services.medialive.model.H264EntropyEncoding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264EntropyEncoding.CABAC =>
      val r = CABAC
      r
    case software.amazon.awssdk.services.medialive.model.H264EntropyEncoding.CAVLC =>
      val r = CAVLC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264EntropyEncoding {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264EntropyEncoding =
      software.amazon.awssdk.services.medialive.model.H264EntropyEncoding.UNKNOWN_TO_SDK_VERSION
  }
  case object CABAC extends zio.aws.medialive.model.H264EntropyEncoding {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264EntropyEncoding =
      software.amazon.awssdk.services.medialive.model.H264EntropyEncoding.CABAC
  }
  case object CAVLC extends zio.aws.medialive.model.H264EntropyEncoding {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264EntropyEncoding =
      software.amazon.awssdk.services.medialive.model.H264EntropyEncoding.CAVLC
  }
}
