package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class H264FilterSettings(
    temporalFilterSettings: Option[
      zio.aws.medialive.model.TemporalFilterSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.H264FilterSettings = {
    import H264FilterSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.H264FilterSettings
      .builder()
      .optionallyWith(
        temporalFilterSettings.map(value => value.buildAwsValue())
      )(_.temporalFilterSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.H264FilterSettings.ReadOnly =
    zio.aws.medialive.model.H264FilterSettings.wrap(buildAwsValue())
}
object H264FilterSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.H264FilterSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.H264FilterSettings =
      zio.aws.medialive.model.H264FilterSettings(
        temporalFilterSettings.map(value => value.asEditable)
      )
    def temporalFilterSettings
        : Option[zio.aws.medialive.model.TemporalFilterSettings.ReadOnly]
    def getTemporalFilterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TemporalFilterSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "temporalFilterSettings",
      temporalFilterSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.H264FilterSettings
  ) extends zio.aws.medialive.model.H264FilterSettings.ReadOnly {
    override val temporalFilterSettings
        : Option[zio.aws.medialive.model.TemporalFilterSettings.ReadOnly] =
      scala
        .Option(impl.temporalFilterSettings())
        .map(value =>
          zio.aws.medialive.model.TemporalFilterSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.H264FilterSettings
  ): zio.aws.medialive.model.H264FilterSettings.ReadOnly = new Wrapper(impl)
}
