package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264FramerateControl {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H264FramerateControl
}
object H264FramerateControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264FramerateControl
  ): zio.aws.medialive.model.H264FramerateControl = value match {
    case software.amazon.awssdk.services.medialive.model.H264FramerateControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264FramerateControl.INITIALIZE_FROM_SOURCE =>
      val r = INITIALIZE_FROM_SOURCE
      r
    case software.amazon.awssdk.services.medialive.model.H264FramerateControl.SPECIFIED =>
      val r = SPECIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264FramerateControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264FramerateControl =
      software.amazon.awssdk.services.medialive.model.H264FramerateControl.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZE_FROM_SOURCE
      extends zio.aws.medialive.model.H264FramerateControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264FramerateControl =
      software.amazon.awssdk.services.medialive.model.H264FramerateControl.INITIALIZE_FROM_SOURCE
  }
  case object SPECIFIED extends zio.aws.medialive.model.H264FramerateControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264FramerateControl =
      software.amazon.awssdk.services.medialive.model.H264FramerateControl.SPECIFIED
  }
}
