package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264GopBReference {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264GopBReference
}
object H264GopBReference {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264GopBReference
  ): zio.aws.medialive.model.H264GopBReference = value match {
    case software.amazon.awssdk.services.medialive.model.H264GopBReference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264GopBReference.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.H264GopBReference.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264GopBReference {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264GopBReference =
      software.amazon.awssdk.services.medialive.model.H264GopBReference.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.H264GopBReference {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264GopBReference =
      software.amazon.awssdk.services.medialive.model.H264GopBReference.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.H264GopBReference {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264GopBReference =
      software.amazon.awssdk.services.medialive.model.H264GopBReference.ENABLED
  }
}
