package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264GopSizeUnits {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264GopSizeUnits
}
object H264GopSizeUnits {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264GopSizeUnits
  ): zio.aws.medialive.model.H264GopSizeUnits = value match {
    case software.amazon.awssdk.services.medialive.model.H264GopSizeUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264GopSizeUnits.FRAMES =>
      val r = FRAMES
      r
    case software.amazon.awssdk.services.medialive.model.H264GopSizeUnits.SECONDS =>
      val r = SECONDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.H264GopSizeUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object FRAMES extends zio.aws.medialive.model.H264GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.H264GopSizeUnits.FRAMES
  }
  case object SECONDS extends zio.aws.medialive.model.H264GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.H264GopSizeUnits.SECONDS
  }
}
