package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264ParControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264ParControl
}
object H264ParControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264ParControl
  ): zio.aws.medialive.model.H264ParControl = value match {
    case software.amazon.awssdk.services.medialive.model.H264ParControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264ParControl.INITIALIZE_FROM_SOURCE =>
      val r = INITIALIZE_FROM_SOURCE
      r
    case software.amazon.awssdk.services.medialive.model.H264ParControl.SPECIFIED =>
      val r = SPECIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264ParControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ParControl =
      software.amazon.awssdk.services.medialive.model.H264ParControl.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZE_FROM_SOURCE
      extends zio.aws.medialive.model.H264ParControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ParControl =
      software.amazon.awssdk.services.medialive.model.H264ParControl.INITIALIZE_FROM_SOURCE
  }
  case object SPECIFIED extends zio.aws.medialive.model.H264ParControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ParControl =
      software.amazon.awssdk.services.medialive.model.H264ParControl.SPECIFIED
  }
}
