package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264Profile {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264Profile
}
object H264Profile {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264Profile
  ): zio.aws.medialive.model.H264Profile = value match {
    case software.amazon.awssdk.services.medialive.model.H264Profile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264Profile.BASELINE =>
      val r = BASELINE
      r
    case software.amazon.awssdk.services.medialive.model.H264Profile.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.medialive.model.H264Profile.HIGH_10_BIT =>
      val r = HIGH_10BIT
      r
    case software.amazon.awssdk.services.medialive.model.H264Profile.HIGH_422 =>
      val r = HIGH_422
      r
    case software.amazon.awssdk.services.medialive.model.H264Profile.HIGH_422_10_BIT =>
      val r = HIGH_422_10BIT
      r
    case software.amazon.awssdk.services.medialive.model.H264Profile.MAIN =>
      val r = MAIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.UNKNOWN_TO_SDK_VERSION
  }
  case object BASELINE extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.BASELINE
  }
  case object HIGH extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.HIGH
  }
  case object HIGH_10BIT extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.HIGH_10_BIT
  }
  case object HIGH_422 extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.HIGH_422
  }
  case object HIGH_422_10BIT extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.HIGH_422_10_BIT
  }
  case object MAIN extends zio.aws.medialive.model.H264Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Profile =
      software.amazon.awssdk.services.medialive.model.H264Profile.MAIN
  }
}
