package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264QualityLevel {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264QualityLevel
}
object H264QualityLevel {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264QualityLevel
  ): zio.aws.medialive.model.H264QualityLevel = value match {
    case software.amazon.awssdk.services.medialive.model.H264QualityLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264QualityLevel.ENHANCED_QUALITY =>
      val r = ENHANCED_QUALITY
      r
    case software.amazon.awssdk.services.medialive.model.H264QualityLevel.STANDARD_QUALITY =>
      val r = STANDARD_QUALITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264QualityLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264QualityLevel =
      software.amazon.awssdk.services.medialive.model.H264QualityLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ENHANCED_QUALITY
      extends zio.aws.medialive.model.H264QualityLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264QualityLevel =
      software.amazon.awssdk.services.medialive.model.H264QualityLevel.ENHANCED_QUALITY
  }
  case object STANDARD_QUALITY
      extends zio.aws.medialive.model.H264QualityLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264QualityLevel =
      software.amazon.awssdk.services.medialive.model.H264QualityLevel.STANDARD_QUALITY
  }
}
