package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264RateControlMode {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H264RateControlMode
}
object H264RateControlMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264RateControlMode
  ): zio.aws.medialive.model.H264RateControlMode = value match {
    case software.amazon.awssdk.services.medialive.model.H264RateControlMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264RateControlMode.CBR =>
      val r = CBR
      r
    case software.amazon.awssdk.services.medialive.model.H264RateControlMode.MULTIPLEX =>
      val r = MULTIPLEX
      r
    case software.amazon.awssdk.services.medialive.model.H264RateControlMode.QVBR =>
      val r = QVBR
      r
    case software.amazon.awssdk.services.medialive.model.H264RateControlMode.VBR =>
      val r = VBR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264RateControlMode =
      software.amazon.awssdk.services.medialive.model.H264RateControlMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CBR extends zio.aws.medialive.model.H264RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264RateControlMode =
      software.amazon.awssdk.services.medialive.model.H264RateControlMode.CBR
  }
  case object MULTIPLEX extends zio.aws.medialive.model.H264RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264RateControlMode =
      software.amazon.awssdk.services.medialive.model.H264RateControlMode.MULTIPLEX
  }
  case object QVBR extends zio.aws.medialive.model.H264RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264RateControlMode =
      software.amazon.awssdk.services.medialive.model.H264RateControlMode.QVBR
  }
  case object VBR extends zio.aws.medialive.model.H264RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264RateControlMode =
      software.amazon.awssdk.services.medialive.model.H264RateControlMode.VBR
  }
}
