package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264ScanType {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264ScanType
}
object H264ScanType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264ScanType
  ): zio.aws.medialive.model.H264ScanType = value match {
    case software.amazon.awssdk.services.medialive.model.H264ScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264ScanType.INTERLACED =>
      val r = INTERLACED
      r
    case software.amazon.awssdk.services.medialive.model.H264ScanType.PROGRESSIVE =>
      val r = PROGRESSIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H264ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ScanType =
      software.amazon.awssdk.services.medialive.model.H264ScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERLACED extends zio.aws.medialive.model.H264ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ScanType =
      software.amazon.awssdk.services.medialive.model.H264ScanType.INTERLACED
  }
  case object PROGRESSIVE extends zio.aws.medialive.model.H264ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264ScanType =
      software.amazon.awssdk.services.medialive.model.H264ScanType.PROGRESSIVE
  }
}
