package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264SceneChangeDetect {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect
}
object H264SceneChangeDetect {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect
  ): zio.aws.medialive.model.H264SceneChangeDetect = value match {
    case software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264SceneChangeDetect {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect =
      software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.H264SceneChangeDetect {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect =
      software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.H264SceneChangeDetect {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect =
      software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect.ENABLED
  }
}
