package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin1000,
  __integerMin1Max10,
  __integerMin0,
  __double,
  __integerMin1Max6,
  __integerMin1,
  __integerMin0Max30,
  __integerMin0Max7,
  __integerMin1Max32,
  __integerMin0Max128,
  __integerMin0Max100
}
import scala.jdk.CollectionConverters._
final case class H264Settings(
    adaptiveQuantization: Option[
      zio.aws.medialive.model.H264AdaptiveQuantization
    ] = None,
    afdSignaling: Option[zio.aws.medialive.model.AfdSignaling] = None,
    bitrate: Option[__integerMin1000] = None,
    bufFillPct: Option[__integerMin0Max100] = None,
    bufSize: Option[__integerMin0] = None,
    colorMetadata: Option[zio.aws.medialive.model.H264ColorMetadata] = None,
    colorSpaceSettings: Option[zio.aws.medialive.model.H264ColorSpaceSettings] =
      None,
    entropyEncoding: Option[zio.aws.medialive.model.H264EntropyEncoding] = None,
    filterSettings: Option[zio.aws.medialive.model.H264FilterSettings] = None,
    fixedAfd: Option[zio.aws.medialive.model.FixedAfd] = None,
    flickerAq: Option[zio.aws.medialive.model.H264FlickerAq] = None,
    forceFieldPictures: Option[zio.aws.medialive.model.H264ForceFieldPictures] =
      None,
    framerateControl: Option[zio.aws.medialive.model.H264FramerateControl] =
      None,
    framerateDenominator: Option[__integerMin1] = None,
    framerateNumerator: Option[__integerMin1] = None,
    gopBReference: Option[zio.aws.medialive.model.H264GopBReference] = None,
    gopClosedCadence: Option[__integerMin0] = None,
    gopNumBFrames: Option[__integerMin0Max7] = None,
    gopSize: Option[__double] = None,
    gopSizeUnits: Option[zio.aws.medialive.model.H264GopSizeUnits] = None,
    level: Option[zio.aws.medialive.model.H264Level] = None,
    lookAheadRateControl: Option[
      zio.aws.medialive.model.H264LookAheadRateControl
    ] = None,
    maxBitrate: Option[__integerMin1000] = None,
    minIInterval: Option[__integerMin0Max30] = None,
    numRefFrames: Option[__integerMin1Max6] = None,
    parControl: Option[zio.aws.medialive.model.H264ParControl] = None,
    parDenominator: Option[__integerMin1] = None,
    parNumerator: Option[__integerMin1] = None,
    profile: Option[zio.aws.medialive.model.H264Profile] = None,
    qualityLevel: Option[zio.aws.medialive.model.H264QualityLevel] = None,
    qvbrQualityLevel: Option[__integerMin1Max10] = None,
    rateControlMode: Option[zio.aws.medialive.model.H264RateControlMode] = None,
    scanType: Option[zio.aws.medialive.model.H264ScanType] = None,
    sceneChangeDetect: Option[zio.aws.medialive.model.H264SceneChangeDetect] =
      None,
    slices: Option[__integerMin1Max32] = None,
    softness: Option[__integerMin0Max128] = None,
    spatialAq: Option[zio.aws.medialive.model.H264SpatialAq] = None,
    subgopLength: Option[zio.aws.medialive.model.H264SubGopLength] = None,
    syntax: Option[zio.aws.medialive.model.H264Syntax] = None,
    temporalAq: Option[zio.aws.medialive.model.H264TemporalAq] = None,
    timecodeInsertion: Option[
      zio.aws.medialive.model.H264TimecodeInsertionBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.H264Settings = {
    import H264Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.H264Settings
      .builder()
      .optionallyWith(adaptiveQuantization.map(value => value.unwrap))(
        _.adaptiveQuantization
      )
      .optionallyWith(afdSignaling.map(value => value.unwrap))(_.afdSignaling)
      .optionallyWith(bitrate.map(value => value: Integer))(_.bitrate)
      .optionallyWith(bufFillPct.map(value => value: Integer))(_.bufFillPct)
      .optionallyWith(bufSize.map(value => value: Integer))(_.bufSize)
      .optionallyWith(colorMetadata.map(value => value.unwrap))(_.colorMetadata)
      .optionallyWith(colorSpaceSettings.map(value => value.buildAwsValue()))(
        _.colorSpaceSettings
      )
      .optionallyWith(entropyEncoding.map(value => value.unwrap))(
        _.entropyEncoding
      )
      .optionallyWith(filterSettings.map(value => value.buildAwsValue()))(
        _.filterSettings
      )
      .optionallyWith(fixedAfd.map(value => value.unwrap))(_.fixedAfd)
      .optionallyWith(flickerAq.map(value => value.unwrap))(_.flickerAq)
      .optionallyWith(forceFieldPictures.map(value => value.unwrap))(
        _.forceFieldPictures
      )
      .optionallyWith(framerateControl.map(value => value.unwrap))(
        _.framerateControl
      )
      .optionallyWith(framerateDenominator.map(value => value: Integer))(
        _.framerateDenominator
      )
      .optionallyWith(framerateNumerator.map(value => value: Integer))(
        _.framerateNumerator
      )
      .optionallyWith(gopBReference.map(value => value.unwrap))(_.gopBReference)
      .optionallyWith(gopClosedCadence.map(value => value: Integer))(
        _.gopClosedCadence
      )
      .optionallyWith(gopNumBFrames.map(value => value: Integer))(
        _.gopNumBFrames
      )
      .optionallyWith(gopSize.map(value => value: java.lang.Double))(_.gopSize)
      .optionallyWith(gopSizeUnits.map(value => value.unwrap))(_.gopSizeUnits)
      .optionallyWith(level.map(value => value.unwrap))(_.level)
      .optionallyWith(lookAheadRateControl.map(value => value.unwrap))(
        _.lookAheadRateControl
      )
      .optionallyWith(maxBitrate.map(value => value: Integer))(_.maxBitrate)
      .optionallyWith(minIInterval.map(value => value: Integer))(_.minIInterval)
      .optionallyWith(numRefFrames.map(value => value: Integer))(_.numRefFrames)
      .optionallyWith(parControl.map(value => value.unwrap))(_.parControl)
      .optionallyWith(parDenominator.map(value => value: Integer))(
        _.parDenominator
      )
      .optionallyWith(parNumerator.map(value => value: Integer))(_.parNumerator)
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(qualityLevel.map(value => value.unwrap))(_.qualityLevel)
      .optionallyWith(qvbrQualityLevel.map(value => value: Integer))(
        _.qvbrQualityLevel
      )
      .optionallyWith(rateControlMode.map(value => value.unwrap))(
        _.rateControlMode
      )
      .optionallyWith(scanType.map(value => value.unwrap))(_.scanType)
      .optionallyWith(sceneChangeDetect.map(value => value.unwrap))(
        _.sceneChangeDetect
      )
      .optionallyWith(slices.map(value => value: Integer))(_.slices)
      .optionallyWith(softness.map(value => value: Integer))(_.softness)
      .optionallyWith(spatialAq.map(value => value.unwrap))(_.spatialAq)
      .optionallyWith(subgopLength.map(value => value.unwrap))(_.subgopLength)
      .optionallyWith(syntax.map(value => value.unwrap))(_.syntax)
      .optionallyWith(temporalAq.map(value => value.unwrap))(_.temporalAq)
      .optionallyWith(timecodeInsertion.map(value => value.unwrap))(
        _.timecodeInsertion
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.H264Settings.ReadOnly =
    zio.aws.medialive.model.H264Settings.wrap(buildAwsValue())
}
object H264Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.H264Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.H264Settings =
      zio.aws.medialive.model.H264Settings(
        adaptiveQuantization.map(value => value),
        afdSignaling.map(value => value),
        bitrate.map(value => value),
        bufFillPct.map(value => value),
        bufSize.map(value => value),
        colorMetadata.map(value => value),
        colorSpaceSettings.map(value => value.asEditable),
        entropyEncoding.map(value => value),
        filterSettings.map(value => value.asEditable),
        fixedAfd.map(value => value),
        flickerAq.map(value => value),
        forceFieldPictures.map(value => value),
        framerateControl.map(value => value),
        framerateDenominator.map(value => value),
        framerateNumerator.map(value => value),
        gopBReference.map(value => value),
        gopClosedCadence.map(value => value),
        gopNumBFrames.map(value => value),
        gopSize.map(value => value),
        gopSizeUnits.map(value => value),
        level.map(value => value),
        lookAheadRateControl.map(value => value),
        maxBitrate.map(value => value),
        minIInterval.map(value => value),
        numRefFrames.map(value => value),
        parControl.map(value => value),
        parDenominator.map(value => value),
        parNumerator.map(value => value),
        profile.map(value => value),
        qualityLevel.map(value => value),
        qvbrQualityLevel.map(value => value),
        rateControlMode.map(value => value),
        scanType.map(value => value),
        sceneChangeDetect.map(value => value),
        slices.map(value => value),
        softness.map(value => value),
        spatialAq.map(value => value),
        subgopLength.map(value => value),
        syntax.map(value => value),
        temporalAq.map(value => value),
        timecodeInsertion.map(value => value)
      )
    def adaptiveQuantization
        : Option[zio.aws.medialive.model.H264AdaptiveQuantization]
    def afdSignaling: Option[zio.aws.medialive.model.AfdSignaling]
    def bitrate: Option[__integerMin1000]
    def bufFillPct: Option[__integerMin0Max100]
    def bufSize: Option[__integerMin0]
    def colorMetadata: Option[zio.aws.medialive.model.H264ColorMetadata]
    def colorSpaceSettings
        : Option[zio.aws.medialive.model.H264ColorSpaceSettings.ReadOnly]
    def entropyEncoding: Option[zio.aws.medialive.model.H264EntropyEncoding]
    def filterSettings
        : Option[zio.aws.medialive.model.H264FilterSettings.ReadOnly]
    def fixedAfd: Option[zio.aws.medialive.model.FixedAfd]
    def flickerAq: Option[zio.aws.medialive.model.H264FlickerAq]
    def forceFieldPictures
        : Option[zio.aws.medialive.model.H264ForceFieldPictures]
    def framerateControl: Option[zio.aws.medialive.model.H264FramerateControl]
    def framerateDenominator: Option[__integerMin1]
    def framerateNumerator: Option[__integerMin1]
    def gopBReference: Option[zio.aws.medialive.model.H264GopBReference]
    def gopClosedCadence: Option[__integerMin0]
    def gopNumBFrames: Option[__integerMin0Max7]
    def gopSize: Option[__double]
    def gopSizeUnits: Option[zio.aws.medialive.model.H264GopSizeUnits]
    def level: Option[zio.aws.medialive.model.H264Level]
    def lookAheadRateControl
        : Option[zio.aws.medialive.model.H264LookAheadRateControl]
    def maxBitrate: Option[__integerMin1000]
    def minIInterval: Option[__integerMin0Max30]
    def numRefFrames: Option[__integerMin1Max6]
    def parControl: Option[zio.aws.medialive.model.H264ParControl]
    def parDenominator: Option[__integerMin1]
    def parNumerator: Option[__integerMin1]
    def profile: Option[zio.aws.medialive.model.H264Profile]
    def qualityLevel: Option[zio.aws.medialive.model.H264QualityLevel]
    def qvbrQualityLevel: Option[__integerMin1Max10]
    def rateControlMode: Option[zio.aws.medialive.model.H264RateControlMode]
    def scanType: Option[zio.aws.medialive.model.H264ScanType]
    def sceneChangeDetect: Option[zio.aws.medialive.model.H264SceneChangeDetect]
    def slices: Option[__integerMin1Max32]
    def softness: Option[__integerMin0Max128]
    def spatialAq: Option[zio.aws.medialive.model.H264SpatialAq]
    def subgopLength: Option[zio.aws.medialive.model.H264SubGopLength]
    def syntax: Option[zio.aws.medialive.model.H264Syntax]
    def temporalAq: Option[zio.aws.medialive.model.H264TemporalAq]
    def timecodeInsertion
        : Option[zio.aws.medialive.model.H264TimecodeInsertionBehavior]
    def getAdaptiveQuantization
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264AdaptiveQuantization] =
      AwsError.unwrapOptionField("adaptiveQuantization", adaptiveQuantization)
    def getAfdSignaling
        : ZIO[Any, AwsError, zio.aws.medialive.model.AfdSignaling] =
      AwsError.unwrapOptionField("afdSignaling", afdSignaling)
    def getBitrate: ZIO[Any, AwsError, __integerMin1000] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getBufFillPct: ZIO[Any, AwsError, __integerMin0Max100] =
      AwsError.unwrapOptionField("bufFillPct", bufFillPct)
    def getBufSize: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("bufSize", bufSize)
    def getColorMetadata
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264ColorMetadata] =
      AwsError.unwrapOptionField("colorMetadata", colorMetadata)
    def getColorSpaceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H264ColorSpaceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("colorSpaceSettings", colorSpaceSettings)
    def getEntropyEncoding
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264EntropyEncoding] =
      AwsError.unwrapOptionField("entropyEncoding", entropyEncoding)
    def getFilterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H264FilterSettings.ReadOnly
    ] = AwsError.unwrapOptionField("filterSettings", filterSettings)
    def getFixedAfd: ZIO[Any, AwsError, zio.aws.medialive.model.FixedAfd] =
      AwsError.unwrapOptionField("fixedAfd", fixedAfd)
    def getFlickerAq
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264FlickerAq] =
      AwsError.unwrapOptionField("flickerAq", flickerAq)
    def getForceFieldPictures
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264ForceFieldPictures] =
      AwsError.unwrapOptionField("forceFieldPictures", forceFieldPictures)
    def getFramerateControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264FramerateControl] =
      AwsError.unwrapOptionField("framerateControl", framerateControl)
    def getFramerateDenominator: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("framerateDenominator", framerateDenominator)
    def getFramerateNumerator: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("framerateNumerator", framerateNumerator)
    def getGopBReference
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264GopBReference] =
      AwsError.unwrapOptionField("gopBReference", gopBReference)
    def getGopClosedCadence: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("gopClosedCadence", gopClosedCadence)
    def getGopNumBFrames: ZIO[Any, AwsError, __integerMin0Max7] =
      AwsError.unwrapOptionField("gopNumBFrames", gopNumBFrames)
    def getGopSize: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("gopSize", gopSize)
    def getGopSizeUnits
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264GopSizeUnits] =
      AwsError.unwrapOptionField("gopSizeUnits", gopSizeUnits)
    def getLevel: ZIO[Any, AwsError, zio.aws.medialive.model.H264Level] =
      AwsError.unwrapOptionField("level", level)
    def getLookAheadRateControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264LookAheadRateControl] =
      AwsError.unwrapOptionField("lookAheadRateControl", lookAheadRateControl)
    def getMaxBitrate: ZIO[Any, AwsError, __integerMin1000] =
      AwsError.unwrapOptionField("maxBitrate", maxBitrate)
    def getMinIInterval: ZIO[Any, AwsError, __integerMin0Max30] =
      AwsError.unwrapOptionField("minIInterval", minIInterval)
    def getNumRefFrames: ZIO[Any, AwsError, __integerMin1Max6] =
      AwsError.unwrapOptionField("numRefFrames", numRefFrames)
    def getParControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264ParControl] =
      AwsError.unwrapOptionField("parControl", parControl)
    def getParDenominator: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("parDenominator", parDenominator)
    def getParNumerator: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("parNumerator", parNumerator)
    def getProfile: ZIO[Any, AwsError, zio.aws.medialive.model.H264Profile] =
      AwsError.unwrapOptionField("profile", profile)
    def getQualityLevel
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264QualityLevel] =
      AwsError.unwrapOptionField("qualityLevel", qualityLevel)
    def getQvbrQualityLevel: ZIO[Any, AwsError, __integerMin1Max10] =
      AwsError.unwrapOptionField("qvbrQualityLevel", qvbrQualityLevel)
    def getRateControlMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264RateControlMode] =
      AwsError.unwrapOptionField("rateControlMode", rateControlMode)
    def getScanType: ZIO[Any, AwsError, zio.aws.medialive.model.H264ScanType] =
      AwsError.unwrapOptionField("scanType", scanType)
    def getSceneChangeDetect
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264SceneChangeDetect] =
      AwsError.unwrapOptionField("sceneChangeDetect", sceneChangeDetect)
    def getSlices: ZIO[Any, AwsError, __integerMin1Max32] =
      AwsError.unwrapOptionField("slices", slices)
    def getSoftness: ZIO[Any, AwsError, __integerMin0Max128] =
      AwsError.unwrapOptionField("softness", softness)
    def getSpatialAq
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264SpatialAq] =
      AwsError.unwrapOptionField("spatialAq", spatialAq)
    def getSubgopLength
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264SubGopLength] =
      AwsError.unwrapOptionField("subgopLength", subgopLength)
    def getSyntax: ZIO[Any, AwsError, zio.aws.medialive.model.H264Syntax] =
      AwsError.unwrapOptionField("syntax", syntax)
    def getTemporalAq
        : ZIO[Any, AwsError, zio.aws.medialive.model.H264TemporalAq] =
      AwsError.unwrapOptionField("temporalAq", temporalAq)
    def getTimecodeInsertion: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.H264TimecodeInsertionBehavior
    ] = AwsError.unwrapOptionField("timecodeInsertion", timecodeInsertion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.H264Settings
  ) extends zio.aws.medialive.model.H264Settings.ReadOnly {
    override val adaptiveQuantization
        : Option[zio.aws.medialive.model.H264AdaptiveQuantization] = scala
      .Option(impl.adaptiveQuantization())
      .map(value =>
        zio.aws.medialive.model.H264AdaptiveQuantization.wrap(value)
      )
    override val afdSignaling: Option[zio.aws.medialive.model.AfdSignaling] =
      scala
        .Option(impl.afdSignaling())
        .map(value => zio.aws.medialive.model.AfdSignaling.wrap(value))
    override val bitrate: Option[__integerMin1000] =
      scala.Option(impl.bitrate()).map(value => value: __integerMin1000)
    override val bufFillPct: Option[__integerMin0Max100] =
      scala.Option(impl.bufFillPct()).map(value => value: __integerMin0Max100)
    override val bufSize: Option[__integerMin0] =
      scala.Option(impl.bufSize()).map(value => value: __integerMin0)
    override val colorMetadata
        : Option[zio.aws.medialive.model.H264ColorMetadata] = scala
      .Option(impl.colorMetadata())
      .map(value => zio.aws.medialive.model.H264ColorMetadata.wrap(value))
    override val colorSpaceSettings
        : Option[zio.aws.medialive.model.H264ColorSpaceSettings.ReadOnly] =
      scala
        .Option(impl.colorSpaceSettings())
        .map(value =>
          zio.aws.medialive.model.H264ColorSpaceSettings.wrap(value)
        )
    override val entropyEncoding
        : Option[zio.aws.medialive.model.H264EntropyEncoding] = scala
      .Option(impl.entropyEncoding())
      .map(value => zio.aws.medialive.model.H264EntropyEncoding.wrap(value))
    override val filterSettings
        : Option[zio.aws.medialive.model.H264FilterSettings.ReadOnly] = scala
      .Option(impl.filterSettings())
      .map(value => zio.aws.medialive.model.H264FilterSettings.wrap(value))
    override val fixedAfd: Option[zio.aws.medialive.model.FixedAfd] = scala
      .Option(impl.fixedAfd())
      .map(value => zio.aws.medialive.model.FixedAfd.wrap(value))
    override val flickerAq: Option[zio.aws.medialive.model.H264FlickerAq] =
      scala
        .Option(impl.flickerAq())
        .map(value => zio.aws.medialive.model.H264FlickerAq.wrap(value))
    override val forceFieldPictures
        : Option[zio.aws.medialive.model.H264ForceFieldPictures] = scala
      .Option(impl.forceFieldPictures())
      .map(value => zio.aws.medialive.model.H264ForceFieldPictures.wrap(value))
    override val framerateControl
        : Option[zio.aws.medialive.model.H264FramerateControl] = scala
      .Option(impl.framerateControl())
      .map(value => zio.aws.medialive.model.H264FramerateControl.wrap(value))
    override val framerateDenominator: Option[__integerMin1] = scala
      .Option(impl.framerateDenominator())
      .map(value => value: __integerMin1)
    override val framerateNumerator: Option[__integerMin1] =
      scala.Option(impl.framerateNumerator()).map(value => value: __integerMin1)
    override val gopBReference
        : Option[zio.aws.medialive.model.H264GopBReference] = scala
      .Option(impl.gopBReference())
      .map(value => zio.aws.medialive.model.H264GopBReference.wrap(value))
    override val gopClosedCadence: Option[__integerMin0] =
      scala.Option(impl.gopClosedCadence()).map(value => value: __integerMin0)
    override val gopNumBFrames: Option[__integerMin0Max7] =
      scala.Option(impl.gopNumBFrames()).map(value => value: __integerMin0Max7)
    override val gopSize: Option[__double] =
      scala.Option(impl.gopSize()).map(value => value: __double)
    override val gopSizeUnits
        : Option[zio.aws.medialive.model.H264GopSizeUnits] = scala
      .Option(impl.gopSizeUnits())
      .map(value => zio.aws.medialive.model.H264GopSizeUnits.wrap(value))
    override val level: Option[zio.aws.medialive.model.H264Level] = scala
      .Option(impl.level())
      .map(value => zio.aws.medialive.model.H264Level.wrap(value))
    override val lookAheadRateControl
        : Option[zio.aws.medialive.model.H264LookAheadRateControl] = scala
      .Option(impl.lookAheadRateControl())
      .map(value =>
        zio.aws.medialive.model.H264LookAheadRateControl.wrap(value)
      )
    override val maxBitrate: Option[__integerMin1000] =
      scala.Option(impl.maxBitrate()).map(value => value: __integerMin1000)
    override val minIInterval: Option[__integerMin0Max30] =
      scala.Option(impl.minIInterval()).map(value => value: __integerMin0Max30)
    override val numRefFrames: Option[__integerMin1Max6] =
      scala.Option(impl.numRefFrames()).map(value => value: __integerMin1Max6)
    override val parControl: Option[zio.aws.medialive.model.H264ParControl] =
      scala
        .Option(impl.parControl())
        .map(value => zio.aws.medialive.model.H264ParControl.wrap(value))
    override val parDenominator: Option[__integerMin1] =
      scala.Option(impl.parDenominator()).map(value => value: __integerMin1)
    override val parNumerator: Option[__integerMin1] =
      scala.Option(impl.parNumerator()).map(value => value: __integerMin1)
    override val profile: Option[zio.aws.medialive.model.H264Profile] = scala
      .Option(impl.profile())
      .map(value => zio.aws.medialive.model.H264Profile.wrap(value))
    override val qualityLevel
        : Option[zio.aws.medialive.model.H264QualityLevel] = scala
      .Option(impl.qualityLevel())
      .map(value => zio.aws.medialive.model.H264QualityLevel.wrap(value))
    override val qvbrQualityLevel: Option[__integerMin1Max10] = scala
      .Option(impl.qvbrQualityLevel())
      .map(value => value: __integerMin1Max10)
    override val rateControlMode
        : Option[zio.aws.medialive.model.H264RateControlMode] = scala
      .Option(impl.rateControlMode())
      .map(value => zio.aws.medialive.model.H264RateControlMode.wrap(value))
    override val scanType: Option[zio.aws.medialive.model.H264ScanType] = scala
      .Option(impl.scanType())
      .map(value => zio.aws.medialive.model.H264ScanType.wrap(value))
    override val sceneChangeDetect
        : Option[zio.aws.medialive.model.H264SceneChangeDetect] = scala
      .Option(impl.sceneChangeDetect())
      .map(value => zio.aws.medialive.model.H264SceneChangeDetect.wrap(value))
    override val slices: Option[__integerMin1Max32] =
      scala.Option(impl.slices()).map(value => value: __integerMin1Max32)
    override val softness: Option[__integerMin0Max128] =
      scala.Option(impl.softness()).map(value => value: __integerMin0Max128)
    override val spatialAq: Option[zio.aws.medialive.model.H264SpatialAq] =
      scala
        .Option(impl.spatialAq())
        .map(value => zio.aws.medialive.model.H264SpatialAq.wrap(value))
    override val subgopLength
        : Option[zio.aws.medialive.model.H264SubGopLength] = scala
      .Option(impl.subgopLength())
      .map(value => zio.aws.medialive.model.H264SubGopLength.wrap(value))
    override val syntax: Option[zio.aws.medialive.model.H264Syntax] = scala
      .Option(impl.syntax())
      .map(value => zio.aws.medialive.model.H264Syntax.wrap(value))
    override val temporalAq: Option[zio.aws.medialive.model.H264TemporalAq] =
      scala
        .Option(impl.temporalAq())
        .map(value => zio.aws.medialive.model.H264TemporalAq.wrap(value))
    override val timecodeInsertion
        : Option[zio.aws.medialive.model.H264TimecodeInsertionBehavior] = scala
      .Option(impl.timecodeInsertion())
      .map(value =>
        zio.aws.medialive.model.H264TimecodeInsertionBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.H264Settings
  ): zio.aws.medialive.model.H264Settings.ReadOnly = new Wrapper(impl)
}
