package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264Syntax {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264Syntax
}
object H264Syntax {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264Syntax
  ): zio.aws.medialive.model.H264Syntax = value match {
    case software.amazon.awssdk.services.medialive.model.H264Syntax.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264Syntax.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.medialive.model.H264Syntax.RP2027 =>
      val r = RP2027
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H264Syntax {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Syntax =
      software.amazon.awssdk.services.medialive.model.H264Syntax.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.medialive.model.H264Syntax {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Syntax =
      software.amazon.awssdk.services.medialive.model.H264Syntax.DEFAULT
  }
  case object RP2027 extends zio.aws.medialive.model.H264Syntax {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264Syntax =
      software.amazon.awssdk.services.medialive.model.H264Syntax.RP2027
  }
}
