package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H264TimecodeInsertionBehavior {
  def unwrap: software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior
}
object H264TimecodeInsertionBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior
  ): zio.aws.medialive.model.H264TimecodeInsertionBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior.PIC_TIMING_SEI =>
      val r = PIC_TIMING_SEI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H264TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED
      extends zio.aws.medialive.model.H264TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior.DISABLED
  }
  case object PIC_TIMING_SEI
      extends zio.aws.medialive.model.H264TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior.PIC_TIMING_SEI
  }
}
