package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265AdaptiveQuantization {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization
}
object H265AdaptiveQuantization {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization
  ): zio.aws.medialive.model.H265AdaptiveQuantization = value match {
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.HIGHER =>
      val r = HIGHER
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.MAX =>
      val r = MAX
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.AUTO
  }
  case object HIGH extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.HIGH
  }
  case object HIGHER extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.HIGHER
  }
  case object LOW extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.LOW
  }
  case object MAX extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.MAX
  }
  case object MEDIUM extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.MEDIUM
  }
  case object OFF extends zio.aws.medialive.model.H265AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization.OFF
  }
}
