package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265AlternativeTransferFunction {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction
}
object H265AlternativeTransferFunction {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction
  ): zio.aws.medialive.model.H265AlternativeTransferFunction = value match {
    case software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction.INSERT =>
      val r = INSERT
      r
    case software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction.OMIT =>
      val r = OMIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265AlternativeTransferFunction {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction =
      software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction.UNKNOWN_TO_SDK_VERSION
  }
  case object INSERT
      extends zio.aws.medialive.model.H265AlternativeTransferFunction {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction =
      software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction.INSERT
  }
  case object OMIT
      extends zio.aws.medialive.model.H265AlternativeTransferFunction {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction =
      software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction.OMIT
  }
}
