package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265ColorMetadata {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265ColorMetadata
}
object H265ColorMetadata {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265ColorMetadata
  ): zio.aws.medialive.model.H265ColorMetadata = value match {
    case software.amazon.awssdk.services.medialive.model.H265ColorMetadata.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265ColorMetadata.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.medialive.model.H265ColorMetadata.INSERT =>
      val r = INSERT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265ColorMetadata =
      software.amazon.awssdk.services.medialive.model.H265ColorMetadata.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORE extends zio.aws.medialive.model.H265ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265ColorMetadata =
      software.amazon.awssdk.services.medialive.model.H265ColorMetadata.IGNORE
  }
  case object INSERT extends zio.aws.medialive.model.H265ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265ColorMetadata =
      software.amazon.awssdk.services.medialive.model.H265ColorMetadata.INSERT
  }
}
