package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class H265ColorSpaceSettings(
    colorSpacePassthroughSettings: Option[
      zio.aws.medialive.model.ColorSpacePassthroughSettings
    ] = None,
    hdr10Settings: Option[zio.aws.medialive.model.Hdr10Settings] = None,
    rec601Settings: Option[zio.aws.medialive.model.Rec601Settings] = None,
    rec709Settings: Option[zio.aws.medialive.model.Rec709Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings = {
    import H265ColorSpaceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings
      .builder()
      .optionallyWith(
        colorSpacePassthroughSettings.map(value => value.buildAwsValue())
      )(_.colorSpacePassthroughSettings)
      .optionallyWith(hdr10Settings.map(value => value.buildAwsValue()))(
        _.hdr10Settings
      )
      .optionallyWith(rec601Settings.map(value => value.buildAwsValue()))(
        _.rec601Settings
      )
      .optionallyWith(rec709Settings.map(value => value.buildAwsValue()))(
        _.rec709Settings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.H265ColorSpaceSettings.ReadOnly =
    zio.aws.medialive.model.H265ColorSpaceSettings.wrap(buildAwsValue())
}
object H265ColorSpaceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.H265ColorSpaceSettings =
      zio.aws.medialive.model.H265ColorSpaceSettings(
        colorSpacePassthroughSettings.map(value => value.asEditable),
        hdr10Settings.map(value => value.asEditable),
        rec601Settings.map(value => value.asEditable),
        rec709Settings.map(value => value.asEditable)
      )
    def colorSpacePassthroughSettings
        : Option[zio.aws.medialive.model.ColorSpacePassthroughSettings.ReadOnly]
    def hdr10Settings: Option[zio.aws.medialive.model.Hdr10Settings.ReadOnly]
    def rec601Settings: Option[zio.aws.medialive.model.Rec601Settings.ReadOnly]
    def rec709Settings: Option[zio.aws.medialive.model.Rec709Settings.ReadOnly]
    def getColorSpacePassthroughSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ColorSpacePassthroughSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "colorSpacePassthroughSettings",
      colorSpacePassthroughSettings
    )
    def getHdr10Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Hdr10Settings.ReadOnly] =
      AwsError.unwrapOptionField("hdr10Settings", hdr10Settings)
    def getRec601Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Rec601Settings.ReadOnly] =
      AwsError.unwrapOptionField("rec601Settings", rec601Settings)
    def getRec709Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Rec709Settings.ReadOnly] =
      AwsError.unwrapOptionField("rec709Settings", rec709Settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings
  ) extends zio.aws.medialive.model.H265ColorSpaceSettings.ReadOnly {
    override val colorSpacePassthroughSettings: Option[
      zio.aws.medialive.model.ColorSpacePassthroughSettings.ReadOnly
    ] = scala
      .Option(impl.colorSpacePassthroughSettings())
      .map(value =>
        zio.aws.medialive.model.ColorSpacePassthroughSettings.wrap(value)
      )
    override val hdr10Settings
        : Option[zio.aws.medialive.model.Hdr10Settings.ReadOnly] = scala
      .Option(impl.hdr10Settings())
      .map(value => zio.aws.medialive.model.Hdr10Settings.wrap(value))
    override val rec601Settings
        : Option[zio.aws.medialive.model.Rec601Settings.ReadOnly] = scala
      .Option(impl.rec601Settings())
      .map(value => zio.aws.medialive.model.Rec601Settings.wrap(value))
    override val rec709Settings
        : Option[zio.aws.medialive.model.Rec709Settings.ReadOnly] = scala
      .Option(impl.rec709Settings())
      .map(value => zio.aws.medialive.model.Rec709Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings
  ): zio.aws.medialive.model.H265ColorSpaceSettings.ReadOnly = new Wrapper(impl)
}
