package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class H265FilterSettings(
    temporalFilterSettings: Option[
      zio.aws.medialive.model.TemporalFilterSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.H265FilterSettings = {
    import H265FilterSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.H265FilterSettings
      .builder()
      .optionallyWith(
        temporalFilterSettings.map(value => value.buildAwsValue())
      )(_.temporalFilterSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.H265FilterSettings.ReadOnly =
    zio.aws.medialive.model.H265FilterSettings.wrap(buildAwsValue())
}
object H265FilterSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.H265FilterSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.H265FilterSettings =
      zio.aws.medialive.model.H265FilterSettings(
        temporalFilterSettings.map(value => value.asEditable)
      )
    def temporalFilterSettings
        : Option[zio.aws.medialive.model.TemporalFilterSettings.ReadOnly]
    def getTemporalFilterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TemporalFilterSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "temporalFilterSettings",
      temporalFilterSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.H265FilterSettings
  ) extends zio.aws.medialive.model.H265FilterSettings.ReadOnly {
    override val temporalFilterSettings
        : Option[zio.aws.medialive.model.TemporalFilterSettings.ReadOnly] =
      scala
        .Option(impl.temporalFilterSettings())
        .map(value =>
          zio.aws.medialive.model.TemporalFilterSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.H265FilterSettings
  ): zio.aws.medialive.model.H265FilterSettings.ReadOnly = new Wrapper(impl)
}
