package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265FlickerAq {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265FlickerAq
}
object H265FlickerAq {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265FlickerAq
  ): zio.aws.medialive.model.H265FlickerAq = value match {
    case software.amazon.awssdk.services.medialive.model.H265FlickerAq.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265FlickerAq.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.H265FlickerAq.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265FlickerAq {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265FlickerAq =
      software.amazon.awssdk.services.medialive.model.H265FlickerAq.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.H265FlickerAq {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265FlickerAq =
      software.amazon.awssdk.services.medialive.model.H265FlickerAq.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.H265FlickerAq {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265FlickerAq =
      software.amazon.awssdk.services.medialive.model.H265FlickerAq.ENABLED
  }
}
