package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265GopSizeUnits {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265GopSizeUnits
}
object H265GopSizeUnits {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265GopSizeUnits
  ): zio.aws.medialive.model.H265GopSizeUnits = value match {
    case software.amazon.awssdk.services.medialive.model.H265GopSizeUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265GopSizeUnits.FRAMES =>
      val r = FRAMES
      r
    case software.amazon.awssdk.services.medialive.model.H265GopSizeUnits.SECONDS =>
      val r = SECONDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.H265GopSizeUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object FRAMES extends zio.aws.medialive.model.H265GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.H265GopSizeUnits.FRAMES
  }
  case object SECONDS extends zio.aws.medialive.model.H265GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.H265GopSizeUnits.SECONDS
  }
}
