package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265Level {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265Level
}
object H265Level {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265Level
  ): zio.aws.medialive.model.H265Level = value match {
    case software.amazon.awssdk.services.medialive.model.H265Level.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_1 =>
      val r = H265_LEVEL_1
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_2 =>
      val r = H265_LEVEL_2
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_2_1 =>
      val r = H265_LEVEL_2_1
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_3 =>
      val r = H265_LEVEL_3
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_3_1 =>
      val r = H265_LEVEL_3_1
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_4 =>
      val r = H265_LEVEL_4
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_4_1 =>
      val r = H265_LEVEL_4_1
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_5 =>
      val r = H265_LEVEL_5
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_5_1 =>
      val r = H265_LEVEL_5_1
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_5_2 =>
      val r = H265_LEVEL_5_2
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_6 =>
      val r = H265_LEVEL_6
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_6_1 =>
      val r = H265_LEVEL_6_1
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_6_2 =>
      val r = H265_LEVEL_6_2
      r
    case software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_AUTO =>
      val r = H265_LEVEL_AUTO
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.UNKNOWN_TO_SDK_VERSION
  }
  case object H265_LEVEL_1 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_1
  }
  case object H265_LEVEL_2 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_2
  }
  case object H265_LEVEL_2_1 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_2_1
  }
  case object H265_LEVEL_3 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_3
  }
  case object H265_LEVEL_3_1 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_3_1
  }
  case object H265_LEVEL_4 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_4
  }
  case object H265_LEVEL_4_1 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_4_1
  }
  case object H265_LEVEL_5 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_5
  }
  case object H265_LEVEL_5_1 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_5_1
  }
  case object H265_LEVEL_5_2 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_5_2
  }
  case object H265_LEVEL_6 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_6
  }
  case object H265_LEVEL_6_1 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_6_1
  }
  case object H265_LEVEL_6_2 extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_6_2
  }
  case object H265_LEVEL_AUTO extends zio.aws.medialive.model.H265Level {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Level =
      software.amazon.awssdk.services.medialive.model.H265Level.H265_LEVEL_AUTO
  }
}
