package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265Profile {
  def unwrap: software.amazon.awssdk.services.medialive.model.H265Profile
}
object H265Profile {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265Profile
  ): zio.aws.medialive.model.H265Profile = value match {
    case software.amazon.awssdk.services.medialive.model.H265Profile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265Profile.MAIN =>
      val r = MAIN
      r
    case software.amazon.awssdk.services.medialive.model.H265Profile.MAIN_10_BIT =>
      val r = MAIN_10BIT
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.H265Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Profile =
      software.amazon.awssdk.services.medialive.model.H265Profile.UNKNOWN_TO_SDK_VERSION
  }
  case object MAIN extends zio.aws.medialive.model.H265Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Profile =
      software.amazon.awssdk.services.medialive.model.H265Profile.MAIN
  }
  case object MAIN_10BIT extends zio.aws.medialive.model.H265Profile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265Profile =
      software.amazon.awssdk.services.medialive.model.H265Profile.MAIN_10_BIT
  }
}
