package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait H265RateControlMode {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.H265RateControlMode
}
object H265RateControlMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.H265RateControlMode
  ): zio.aws.medialive.model.H265RateControlMode = value match {
    case software.amazon.awssdk.services.medialive.model.H265RateControlMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.H265RateControlMode.CBR =>
      val r = CBR
      r
    case software.amazon.awssdk.services.medialive.model.H265RateControlMode.MULTIPLEX =>
      val r = MULTIPLEX
      r
    case software.amazon.awssdk.services.medialive.model.H265RateControlMode.QVBR =>
      val r = QVBR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.H265RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265RateControlMode =
      software.amazon.awssdk.services.medialive.model.H265RateControlMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CBR extends zio.aws.medialive.model.H265RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265RateControlMode =
      software.amazon.awssdk.services.medialive.model.H265RateControlMode.CBR
  }
  case object MULTIPLEX extends zio.aws.medialive.model.H265RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265RateControlMode =
      software.amazon.awssdk.services.medialive.model.H265RateControlMode.MULTIPLEX
  }
  case object QVBR extends zio.aws.medialive.model.H265RateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.H265RateControlMode =
      software.amazon.awssdk.services.medialive.model.H265RateControlMode.QVBR
  }
}
